/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import zipkin.Span;
import zipkin.internal.Util;

public abstract class CollectorSampler {
    public static final CollectorSampler ALWAYS_SAMPLE = CollectorSampler.create(1.0f);

    public static CollectorSampler create(float rate) {
        Util.checkArgument(rate >= 0.0f && rate <= 1.0f, "rate should be between 0 and 1: was %s", Float.valueOf(rate));
        final long boundary = (long)(9.223372E18f * rate);
        return new CollectorSampler(){

            @Override
            protected long boundary() {
                return boundary;
            }
        };
    }

    protected abstract long boundary();

    public boolean isSampled(Span span) {
        if (span.debug != null && span.debug.booleanValue()) {
            return true;
        }
        long t = span.traceId == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(span.traceId);
        return t <= this.boundary();
    }

    public String toString() {
        return "CollectorSampler(" + this.boundary() + ")";
    }

    protected CollectorSampler() {
    }
}

