/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.concurrent.Executor;
import zipkin.Component;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.InMemorySpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;

public final class InMemoryStorage
implements StorageComponent {
    final InMemorySpanStore spanStore;
    final AsyncSpanStore asyncSpanStore;
    final AsyncSpanConsumer asyncConsumer;

    public static Builder builder() {
        return new Builder();
    }

    public InMemoryStorage() {
        this(new Builder());
    }

    InMemoryStorage(Builder builder) {
        this.spanStore = new InMemorySpanStore(builder);
        Executor callingThread = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.asyncSpanStore = StorageAdapters.blockingToAsync(this.spanStore, callingThread);
        this.asyncConsumer = StorageAdapters.blockingToAsync(this.spanStore.spanConsumer, callingThread);
    }

    @Override
    public InMemorySpanStore spanStore() {
        return this.spanStore;
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public StorageAdapters.SpanConsumer spanConsumer() {
        return this.spanStore.spanConsumer;
    }

    @Override
    public AsyncSpanConsumer asyncSpanConsumer() {
        return this.asyncConsumer;
    }

    public void clear() {
        this.spanStore.clear();
    }

    public int acceptedSpanCount() {
        return this.spanStore.acceptedSpanCount;
    }

    @Override
    public Component.CheckResult check() {
        return Component.CheckResult.OK;
    }

    @Override
    public void close() {
    }

    public static final class Builder
    implements StorageComponent.Builder {
        boolean strictTraceId = true;

        @Override
        public Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        @Override
        public InMemoryStorage build() {
            return new InMemoryStorage(this);
        }
    }
}

