/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class Span
implements Comparable<Span>,
Serializable {
    private static final long serialVersionUID = 0L;
    public final long traceIdHigh;
    public final long traceId;
    public final String name;
    public final long id;
    @Nullable
    public final Long parentId;
    @Nullable
    public final Long timestamp;
    @Nullable
    public final Long duration;
    public final List<Annotation> annotations;
    public final List<BinaryAnnotation> binaryAnnotations;
    @Nullable
    public final Boolean debug;

    Span(Builder builder) {
        this.traceId = builder.traceId;
        this.traceIdHigh = builder.traceIdHigh != null ? builder.traceIdHigh : 0L;
        this.name = Util.checkNotNull(builder.name, "name").isEmpty() ? "" : builder.name.toLowerCase(Locale.ROOT);
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.timestamp = builder.timestamp;
        this.duration = builder.duration;
        this.annotations = Util.sortedList(builder.annotations);
        this.binaryAnnotations = Util.sortedList(builder.binaryAnnotations);
        this.debug = builder.debug;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return new String(Codec.JSON.writeSpan(this), Util.UTF_8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Span) {
            Span that = (Span)o;
            return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId && this.name.equals(that.name) && this.id == that.id && Util.equal(this.parentId, that.parentId) && Util.equal(this.timestamp, that.timestamp) && Util.equal(this.duration, that.duration) && this.annotations.equals(that.annotations) && this.binaryAnnotations.equals(that.binaryAnnotations) && Util.equal(this.debug, that.debug);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.traceIdHigh >>> 32 ^ this.traceIdHigh));
        h *= 1000003;
        h = (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.id >>> 32 ^ this.id));
        h *= 1000003;
        h ^= this.parentId == null ? 0 : this.parentId.hashCode();
        h *= 1000003;
        h ^= this.timestamp == null ? 0 : this.timestamp.hashCode();
        h *= 1000003;
        h ^= this.duration == null ? 0 : this.duration.hashCode();
        h *= 1000003;
        h ^= this.annotations.hashCode();
        h *= 1000003;
        h ^= this.binaryAnnotations.hashCode();
        h *= 1000003;
        return h ^= this.debug == null ? 0 : this.debug.hashCode();
    }

    @Override
    public int compareTo(Span that) {
        int byTimestamp;
        long y;
        if (this == that) {
            return 0;
        }
        long x = this.timestamp == null ? Long.MIN_VALUE : this.timestamp;
        long l = y = that.timestamp == null ? Long.MIN_VALUE : that.timestamp;
        int n = x < y ? -1 : (byTimestamp = x == y ? 0 : 1);
        if (byTimestamp != 0) {
            return byTimestamp;
        }
        return this.name.compareTo(that.name);
    }

    public String idString() {
        int resultLength = 51;
        if (this.traceIdHigh != 0L) {
            resultLength += 16;
        }
        char[] result = new char[resultLength];
        int pos = 0;
        if (this.traceIdHigh != 0L) {
            Util.writeHexLong(result, pos, this.traceIdHigh);
            pos += 16;
        }
        Util.writeHexLong(result, pos, this.traceId);
        pos += 16;
        result[pos++] = 46;
        Util.writeHexLong(result, pos, this.id);
        pos += 16;
        result[pos++] = 60;
        result[pos++] = 58;
        Util.writeHexLong(result, pos, this.parentId != null ? this.parentId : this.id);
        return new String(result);
    }

    public Set<String> serviceNames() {
        HashSet<String> result = new HashSet<String>();
        for (Annotation annotation : this.annotations) {
            if (annotation.endpoint == null || annotation.endpoint.serviceName.isEmpty()) continue;
            result.add(annotation.endpoint.serviceName);
        }
        for (BinaryAnnotation binaryAnnotation : this.binaryAnnotations) {
            if (binaryAnnotation.endpoint == null || binaryAnnotation.endpoint.serviceName.isEmpty()) continue;
            result.add(binaryAnnotation.endpoint.serviceName);
        }
        return result;
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(Codec.THRIFT.writeSpan(this));
    }

    static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] bytes;

        SerializedForm(byte[] bytes) {
            this.bytes = bytes;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return Codec.THRIFT.readSpan(this.bytes);
            }
            catch (IllegalArgumentException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
        }
    }

    public static final class Builder {
        Long traceId;
        Long traceIdHigh;
        String name;
        Long id;
        Long parentId;
        Long timestamp;
        Long duration;
        HashSet<Annotation> annotations;
        HashSet<BinaryAnnotation> binaryAnnotations;
        Boolean debug;

        Builder() {
        }

        Builder(Span source) {
            this.traceId = source.traceId;
            this.traceIdHigh = source.traceIdHigh;
            this.name = source.name;
            this.id = source.id;
            this.parentId = source.parentId;
            this.timestamp = source.timestamp;
            this.duration = source.duration;
            if (!source.annotations.isEmpty()) {
                this.annotations(source.annotations);
            }
            if (!source.binaryAnnotations.isEmpty()) {
                this.binaryAnnotations(source.binaryAnnotations);
            }
            this.debug = source.debug;
        }

        public Builder merge(Span that) {
            if (this.traceId == null) {
                this.traceId = that.traceId;
            }
            if (this.traceIdHigh == 0L) {
                this.traceIdHigh = that.traceIdHigh;
            }
            if (this.name == null || this.name.length() == 0 || this.name.equals("unknown")) {
                this.name = that.name;
            }
            if (this.id == null) {
                this.id = that.id;
            }
            if (this.parentId == null) {
                this.parentId = that.parentId;
            }
            if (this.timestamp == null || that.timestamp == null || this.timestamp.equals(that.timestamp)) {
                Long l = this.timestamp = this.timestamp != null ? this.timestamp : that.timestamp;
                if (this.duration == null) {
                    this.duration = that.duration;
                } else if (that.duration != null) {
                    this.duration = Math.max(this.duration, that.duration);
                }
            } else {
                long thisEndTs = this.duration != null ? this.timestamp + this.duration : this.timestamp;
                long thatEndTs = that.duration != null ? that.timestamp + that.duration : that.timestamp;
                this.timestamp = Math.min(this.timestamp, that.timestamp);
                this.duration = Math.max(thisEndTs, thatEndTs) - this.timestamp;
            }
            for (Annotation annotation : that.annotations) {
                this.addAnnotation(annotation);
            }
            for (BinaryAnnotation binaryAnnotation : that.binaryAnnotations) {
                this.addBinaryAnnotation(binaryAnnotation);
            }
            if (this.debug == null) {
                this.debug = that.debug;
            }
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp != null && timestamp == 0L ? null : timestamp;
            return this;
        }

        public Builder duration(@Nullable Long duration) {
            this.duration = duration != null && duration == 0L ? null : duration;
            return this;
        }

        public Builder annotations(Collection<Annotation> annotations) {
            this.annotations = new HashSet<Annotation>(annotations);
            return this;
        }

        public Builder addAnnotation(Annotation annotation) {
            if (this.annotations == null) {
                this.annotations = new HashSet();
            }
            this.annotations.add(annotation);
            return this;
        }

        public Builder binaryAnnotations(Collection<BinaryAnnotation> binaryAnnotations) {
            this.binaryAnnotations = new HashSet<BinaryAnnotation>(binaryAnnotations);
            return this;
        }

        public Builder addBinaryAnnotation(BinaryAnnotation binaryAnnotation) {
            if (this.binaryAnnotations == null) {
                this.binaryAnnotations = new HashSet();
            }
            this.binaryAnnotations.add(binaryAnnotation);
            return this;
        }

        public Builder debug(@Nullable Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Span build() {
            return new Span(this);
        }
    }
}

