/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.CallbackCaptor;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

public abstract class StrictTraceIdFalseTest {
    protected abstract StorageComponent storage();

    protected SpanStore store() {
        return this.storage().spanStore();
    }

    protected void accept(Span ... spans) {
        CallbackCaptor captor = new CallbackCaptor();
        this.storage().asyncSpanConsumer().accept(Arrays.asList(spans), (Callback)captor);
        captor.get();
    }

    @Before
    public abstract void clear() throws IOException;

    @Test
    public void getTraces_128BitTraceId_mixed() {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        trace.set(0, ((Span)trace.get(0)).toBuilder().traceIdHigh(1L).build());
        this.accept(trace.toArray(new Span[0]));
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().build())).containsExactly((Object[])new List[]{trace});
    }

    @Test
    public void getTrace_retrieves128bitTraceIdByLower64Bits_mixed() {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        trace.set(0, ((Span)trace.get(0)).toBuilder().traceIdHigh(1L).build());
        this.accept(trace.toArray(new Span[0]));
        Assertions.assertThat((List)this.store().getTrace(0L, ((Span)trace.get((int)0)).traceId)).containsExactlyElementsOf(trace);
        Assertions.assertThat((List)this.store().getTrace(((Span)trace.get((int)0)).traceIdHigh, ((Span)trace.get((int)0)).traceId)).containsExactlyElementsOf(trace);
    }
}

