/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.CallbackCaptor;
import zipkin.internal.Util;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

public abstract class SpanStoreTest {
    long today = Util.midnightUTC((long)System.currentTimeMillis());
    Endpoint ep = Endpoint.create((String)"service", (int)2130706433);
    long spanId = 456L;
    Annotation ann1 = Annotation.create((long)((this.today + 1L) * 1000L), (String)"cs", (Endpoint)this.ep);
    Annotation ann2 = Annotation.create((long)((this.today + 2L) * 1000L), (String)"sr", null);
    Annotation ann3 = Annotation.create((long)((this.today + 10L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Annotation ann4 = Annotation.create((long)((this.today + 20L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Annotation ann5 = Annotation.create((long)((this.today + 5L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Annotation ann6 = Annotation.create((long)((this.today + 6L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Annotation ann7 = Annotation.create((long)((this.today + 7L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Annotation ann8 = Annotation.create((long)((this.today + 8L) * 1000L), (String)"custom", (Endpoint)this.ep);
    Span span1;
    Span span2;
    Span span3;
    Span span4;
    Span span5;
    Span spanEmptySpanName;
    Span spanEmptyServiceName;

    public SpanStoreTest() {
        this.span1 = Span.builder().traceId(123L).name("methodcall").id(this.spanId).timestamp(Long.valueOf(this.ann1.timestamp)).duration(Long.valueOf(9000L)).annotations(Arrays.asList(this.ann1, this.ann3)).addBinaryAnnotation(BinaryAnnotation.create((String)"BAH", (String)"BEH", (Endpoint)this.ep)).build();
        this.span2 = Span.builder().traceId(456L).name("methodcall").id(this.spanId).timestamp(Long.valueOf(this.ann2.timestamp)).addAnnotation(this.ann2).addBinaryAnnotation(BinaryAnnotation.create((String)"BAH2", (String)"BEH2", (Endpoint)this.ep)).build();
        this.span3 = Span.builder().traceId(789L).name("methodcall").id(this.spanId).timestamp(Long.valueOf(this.ann2.timestamp)).duration(Long.valueOf(18000L)).annotations(Arrays.asList(this.ann2, this.ann3, this.ann4)).addBinaryAnnotation(BinaryAnnotation.create((String)"BAH2", (String)"BEH2", (Endpoint)this.ep)).build();
        this.span4 = Span.builder().traceId(999L).name("methodcall").id(this.spanId).timestamp(Long.valueOf(this.ann6.timestamp)).duration(Long.valueOf(1000L)).annotations(Arrays.asList(this.ann6, this.ann7)).build();
        this.span5 = Span.builder().traceId(999L).name("methodcall").id(this.spanId).timestamp(Long.valueOf(this.ann5.timestamp)).duration(Long.valueOf(3000L)).annotations(Arrays.asList(this.ann5, this.ann8)).addBinaryAnnotation(BinaryAnnotation.create((String)"BAH2", (String)"BEH2", (Endpoint)this.ep)).build();
        this.spanEmptySpanName = Span.builder().traceId(123L).name("").id(this.spanId).parentId(Long.valueOf(1L)).timestamp(Long.valueOf(this.ann1.timestamp)).duration(Long.valueOf(1000L)).annotations(Arrays.asList(this.ann1, this.ann2)).build();
        this.spanEmptyServiceName = Span.builder().traceId(123L).name("spanname").id(this.spanId).build();
    }

    protected abstract StorageComponent storage();

    protected SpanStore store() {
        return this.storage().spanStore();
    }

    protected void accept(Span ... spans) {
        CallbackCaptor captor = new CallbackCaptor();
        this.storage().asyncSpanConsumer().accept(Arrays.asList(spans), (Callback)captor);
        captor.get();
    }

    @Before
    public abstract void clear() throws IOException;

    @Test
    public void getTrace_noTraceIdHighDefaultsToZero() {
        this.span1 = TestObjects.TRACE.get(0).toBuilder().traceIdHigh(0L).build();
        this.span2 = this.span1.toBuilder().traceId(1111L).build();
        this.accept(this.span1, this.span2);
        Assertions.assertThat((List)this.store().getTrace(this.span1.traceId)).isEqualTo(Arrays.asList(this.span1));
        Assertions.assertThat((List)this.store().getTrace(0L, this.span1.traceId)).isEqualTo(Arrays.asList(this.span1));
    }

    @Test
    public void getTrace_128() {
        this.span1 = this.span1.toBuilder().traceIdHigh(1L).build();
        this.span2 = this.span1.toBuilder().traceIdHigh(2L).build();
        this.accept(this.span1, this.span2);
        Assertions.assertThat((List)this.store().getTrace(this.span1.traceIdHigh, this.span1.traceId)).isEqualTo(Arrays.asList(this.span1));
        Assertions.assertThat((List)this.store().getTrace(this.span2.traceIdHigh, this.span2.traceId)).isEqualTo(Arrays.asList(this.span2));
    }

    @Test
    public void getTraces_128() {
        Span span1 = TestObjects.TRACE.get(0).toBuilder().traceIdHigh(1L).binaryAnnotations(Arrays.asList(BinaryAnnotation.create((String)"key", (String)"value1", (Endpoint)TestObjects.WEB_ENDPOINT))).build();
        Span span2 = span1.toBuilder().traceIdHigh(2L).binaryAnnotations(Arrays.asList(BinaryAnnotation.create((String)"key", (String)"value2", (Endpoint)TestObjects.WEB_ENDPOINT))).build();
        this.accept(span1, span2);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName(TestObjects.WEB_ENDPOINT.serviceName).addBinaryAnnotation("key", "value2").build())).containsExactly((Object[])new List[]{Arrays.asList(span2)});
    }

    @Test
    public void getTrace_nullWhenNotFound() {
        Assertions.assertThat((List)this.store().getTrace(0L, 111111L)).isNull();
        Assertions.assertThat((List)this.store().getTrace(222222L, 111111L)).isNull();
        Assertions.assertThat((List)this.store().getRawTrace(0L, 111111L)).isNull();
        Assertions.assertThat((List)this.store().getRawTrace(222222L, 111111L)).isNull();
    }

    @Test
    public void tracesRetrieveInOrderDesc() {
        this.accept(this.span2, this.span1.toBuilder().annotations(Arrays.asList(this.ann3, this.ann1)).build());
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).containsOnly((Object[])new List[]{Arrays.asList(this.span2), Arrays.asList(this.span1)});
    }

    @Test
    public void derivesTimestampAndDurationFromAnnotations() {
        this.accept(this.span1.toBuilder().timestamp(null).duration(null).build());
        Assertions.assertThat((List)this.store().getTrace(this.span1.traceIdHigh, this.span1.traceId)).containsOnly((Object[])new Span[]{this.span1});
    }

    @Test
    public void getSpanNames() {
        this.accept(this.span1.toBuilder().name("yak").build(), this.span4);
        Assertions.assertThat((List)this.store().getSpanNames("service")).containsExactly((Object[])new String[]{"methodcall", "yak"});
    }

    @Test
    public void getSpanNames_allReturned() {
        ArrayList<String> spanNames = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            this.accept(this.span1.toBuilder().id((long)i).name("yak" + suffix).build());
            spanNames.add("yak" + suffix);
        }
        Assertions.assertThat((List)this.store().getSpanNames("service")).containsOnlyElementsOf(spanNames);
    }

    @Test
    public void getAllServiceNames_mergesAnnotation_andBinaryAnnotation() {
        BinaryAnnotation yak = BinaryAnnotation.address((String)"sa", (Endpoint)Endpoint.create((String)"yak", (int)2130706433));
        this.accept(this.span1.toBuilder().binaryAnnotations(Arrays.asList(yak)).build());
        Assertions.assertThat((List)this.store().getServiceNames()).containsExactly((Object[])new String[]{"service", "yak"});
    }

    @Test
    public void getAllServiceNames__allReturned() {
        ArrayList<String> serviceNames = new ArrayList<String>();
        serviceNames.add("service");
        for (int i = 0; i < 50; ++i) {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            BinaryAnnotation yak = BinaryAnnotation.address((String)"sa", (Endpoint)Endpoint.create((String)("yak" + suffix), (int)2130706433));
            this.accept(this.span1.toBuilder().id((long)i).addBinaryAnnotation(yak).build());
            serviceNames.add("yak" + suffix);
        }
        Assertions.assertThat((List)this.store().getServiceNames()).containsOnlyElementsOf(serviceNames);
    }

    @Test
    public void allShouldWorkWhenEmpty() {
        QueryRequest.Builder q = QueryRequest.builder().serviceName("service");
        Assertions.assertThat((List)this.store().getTraces(q.build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.spanName("methodcall").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.addAnnotation("custom").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.addBinaryAnnotation("BAH", "BEH").build())).isEmpty();
    }

    @Test
    public void allShouldWorkWhenNoAnnotationsYet() {
        this.accept(this.spanEmptyServiceName);
        QueryRequest.Builder q = QueryRequest.builder().serviceName("service");
        Assertions.assertThat((List)this.store().getTraces(q.build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.spanName("methodcall").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.addAnnotation("custom").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.addBinaryAnnotation("BAH", "BEH").build())).isEmpty();
    }

    @Test
    public void getTraces_spanName() {
        this.accept(this.span1);
        QueryRequest.Builder q = QueryRequest.builder().serviceName("service");
        Assertions.assertThat((List)this.store().getTraces(q.build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(q.spanName("methodcall").build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(q.spanName("badmethod").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("badservice").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(q.spanName(null).build())).isEmpty();
    }

    @Test
    public void getTraces_spanName_128() {
        this.span1 = this.span1.toBuilder().traceIdHigh(1L).name("foo").build();
        this.span2 = this.span1.toBuilder().traceIdHigh(2L).name("bar").build();
        this.accept(this.span1, this.span2);
        QueryRequest.Builder q = QueryRequest.builder().serviceName("service");
        Assertions.assertThat((List)this.store().getTraces(q.spanName(this.span1.name).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
    }

    @Test
    public void getTraces_serviceNameInBinaryAnnotation() {
        Span localTrace = Span.builder().traceId(1L).name("targz").id(1L).timestamp(Long.valueOf(this.today * 1000L + 100L)).duration(Long.valueOf(200L)).addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"archiver", (Endpoint)this.ep)).build();
        this.accept(localTrace);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).containsExactly((Object[])new List[]{Arrays.asList(localTrace)});
    }

    @Test
    public void readsBackLargeValues() {
        char[] kilobyteOfText = new char[1024];
        Arrays.fill(kilobyteOfText, 'a');
        Span span = Span.builder().traceId(1L).name("big").id(1L).timestamp(Long.valueOf(this.today * 1000L + 100L)).duration(Long.valueOf(200L)).addBinaryAnnotation(BinaryAnnotation.create((String)"a", (String)new String(kilobyteOfText), (Endpoint)this.ep)).build();
        this.accept(span);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().build())).containsExactly((Object[])new List[]{Arrays.asList(span)});
        Assertions.assertThat((List)this.store().getTrace(span.traceIdHigh, span.traceId)).isEqualTo(Arrays.asList(span));
    }

    @Test
    public void getTraces_manyTraces() {
        int traceCount = 1000;
        Span span = TestObjects.LOTS_OF_SPANS[0];
        BinaryAnnotation b = (BinaryAnnotation)span.binaryAnnotations.get(0);
        this.accept(Arrays.copyOfRange(TestObjects.LOTS_OF_SPANS, 0, traceCount));
        Assertions.assertThat((List)this.store().getTraces(new QueryRequest.Builder().limit(Integer.valueOf(traceCount)).build())).hasSize(traceCount);
        QueryRequest.Builder builder = QueryRequest.builder().limit(Integer.valueOf(traceCount)).serviceName(b.endpoint.serviceName);
        Assertions.assertThat((List)this.store().getTraces(builder.build())).hasSize(traceCount);
        Assertions.assertThat((List)this.store().getTraces(builder.spanName(span.name).build())).hasSize(traceCount);
        Assertions.assertThat((List)this.store().getTraces(builder.addBinaryAnnotation(b.key, new String(b.value)).build())).hasSize(traceCount);
    }

    @Test
    public void getTraces_duration() {
        Endpoint service1 = Endpoint.create((String)"service1", (int)2130706433);
        Endpoint service2 = Endpoint.create((String)"service2", (int)2130706434);
        Endpoint service3 = Endpoint.create((String)"service3", (int)2130706435);
        BinaryAnnotation.Builder component = BinaryAnnotation.builder().key("lc").value("archiver");
        BinaryAnnotation archiver1 = component.endpoint(service1).build();
        BinaryAnnotation archiver2 = component.endpoint(service2).build();
        BinaryAnnotation archiver3 = component.endpoint(service3).build();
        Span targz = Span.builder().traceId(1L).id(1L).name("targz").timestamp(Long.valueOf(this.today * 1000L + 100L)).duration(Long.valueOf(200L)).addBinaryAnnotation(archiver1).build();
        Span tar = Span.builder().traceId(1L).id(2L).parentId(Long.valueOf(1L)).name("tar").timestamp(Long.valueOf(this.today * 1000L + 200L)).duration(Long.valueOf(150L)).addBinaryAnnotation(archiver2).build();
        Span gz = Span.builder().traceId(1L).id(3L).parentId(Long.valueOf(1L)).name("gz").timestamp(Long.valueOf(this.today * 1000L + 250L)).duration(Long.valueOf(50L)).addBinaryAnnotation(archiver3).build();
        Span zip = Span.builder().traceId(3L).id(3L).name("zip").timestamp(Long.valueOf(this.today * 1000L + 130L)).duration(Long.valueOf(50L)).addBinaryAnnotation(archiver2).build();
        List<Span> trace1 = Arrays.asList(targz, tar, gz);
        List<Span> trace2 = Arrays.asList(targz.toBuilder().traceId(2L).timestamp(Long.valueOf(this.today * 1000L + 110L)).binaryAnnotations(Arrays.asList(archiver3)).build(), tar.toBuilder().traceId(2L).timestamp(Long.valueOf(this.today * 1000L + 210L)).binaryAnnotations(Arrays.asList(archiver2)).build(), gz.toBuilder().traceId(2L).timestamp(Long.valueOf(this.today * 1000L + 260L)).binaryAnnotations(Arrays.asList(archiver1)).build());
        List<Span> trace3 = Arrays.asList(zip);
        this.accept(trace1.toArray(new Span[0]));
        this.accept(trace2.toArray(new Span[0]));
        this.accept(trace3.toArray(new Span[0]));
        long lookback = 43200000L;
        long endTs = this.today + 1L;
        QueryRequest.Builder q = QueryRequest.builder().serviceName("service1").lookback(Long.valueOf(lookback)).endTs(Long.valueOf(endTs));
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("service1").minDuration(targz.duration).build())).containsExactly((Object[])new List[]{trace1});
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("service3").minDuration(targz.duration).build())).containsExactly((Object[])new List[]{trace2});
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("service2").minDuration(zip.duration).maxDuration(tar.duration).build())).containsExactly((Object[])new List[]{trace3, trace2, trace1});
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("service2").spanName("zip").maxDuration(zip.duration).build())).containsExactly((Object[])new List[]{trace3});
        Assertions.assertThat((List)this.store().getTraces(q.serviceName("service2").minDuration(gz.duration).maxDuration(zip.duration).build())).containsExactly((Object[])new List[]{trace3});
    }

    @Test
    public void getTraces_absentWhenNoTimestamp() {
        this.accept(this.span1.toBuilder().timestamp(null).duration(null).annotations(Collections.emptyList()).build());
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").serviceName("methodcall").build())).isEmpty();
        this.accept(this.span1.toBuilder().binaryAnnotations(Collections.emptyList()).build());
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").spanName("methodcall").build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
    }

    @Test
    public void getTraces_annotation() {
        this.accept(this.span1);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").addAnnotation("custom").build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").addBinaryAnnotation("BAH", "BEH").build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
    }

    @Test
    public void getTraces_multipleAnnotationsBecomeAndFilter() {
        Span foo = Span.builder().traceId(1L).name("call1").id(1L).timestamp(Long.valueOf((this.today + 1L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"foo", (Endpoint)this.ep)).build();
        Span barAndFoo = Span.builder().traceId(2L).name("call2").id(2L).timestamp(Long.valueOf((this.today + 2L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 2L) * 1000L), (String)"bar", (Endpoint)this.ep)).addAnnotation(Annotation.create((long)((this.today + 2L) * 1000L), (String)"foo", (Endpoint)this.ep)).build();
        Span fooAndBazAndQux = Span.builder().traceId(3L).name("call3").id(3L).timestamp(Long.valueOf((this.today + 3L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 3L) * 1000L), (String)"foo", (Endpoint)this.ep)).addBinaryAnnotation(BinaryAnnotation.create((String)"baz", (String)"qux", (Endpoint)this.ep)).build();
        Span barAndFooAndBazAndQux = Span.builder().traceId(4L).name("call4").id(4L).timestamp(Long.valueOf((this.today + 4L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 4L) * 1000L), (String)"bar", (Endpoint)this.ep)).addAnnotation(Annotation.create((long)((this.today + 4L) * 1000L), (String)"foo", (Endpoint)this.ep)).addBinaryAnnotation(BinaryAnnotation.create((String)"baz", (String)"qux", (Endpoint)this.ep)).build();
        this.accept(foo, barAndFoo, fooAndBazAndQux, barAndFooAndBazAndQux);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").addAnnotation("foo").build())).containsExactly((Object[])new List[]{Arrays.asList(barAndFooAndBazAndQux), Arrays.asList(fooAndBazAndQux), Arrays.asList(barAndFoo), Arrays.asList(foo)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").addAnnotation("foo").addAnnotation("bar").build())).containsExactly((Object[])new List[]{Arrays.asList(barAndFooAndBazAndQux), Arrays.asList(barAndFoo)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").addAnnotation("foo").addAnnotation("bar").addBinaryAnnotation("baz", "qux").build())).containsExactly((Object[])new List[]{Arrays.asList(barAndFooAndBazAndQux)});
    }

    @Test
    public void getTraces_differentiateOnServiceName() {
        Span trace1 = Span.builder().traceId(1L).name("get").id(1L).timestamp(Long.valueOf((this.today + 1L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"web", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.create((String)"local", (String)"web", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.create((String)"web-b", (String)"web", (Endpoint)TestObjects.WEB_ENDPOINT)).build();
        Span trace2 = Span.builder().traceId(2L).name("get").id(2L).timestamp(Long.valueOf((this.today + 2L) * 1000L)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"cs", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"sr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"ss", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"cr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((this.today + 1L) * 1000L), (String)"app", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.create((String)"local", (String)"app", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.create((String)"app-b", (String)"app", (Endpoint)TestObjects.APP_ENDPOINT)).build();
        this.accept(trace1, trace2);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().build())).containsExactly((Object[])new List[]{Arrays.asList(trace2), Arrays.asList(trace1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addAnnotation("web").build())).containsExactly((Object[])new List[]{Arrays.asList(trace1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addAnnotation("web").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addAnnotation("app").build())).containsExactly((Object[])new List[]{Arrays.asList(trace2)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addAnnotation("app").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addAnnotation("web-b").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addAnnotation("web-b").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addAnnotation("app-b").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addAnnotation("app-b").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addBinaryAnnotation("local", "web").build())).containsExactly((Object[])new List[]{Arrays.asList(trace1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addBinaryAnnotation("local", "web").build())).isEmpty();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("app").addBinaryAnnotation("local", "app").build())).containsExactly((Object[])new List[]{Arrays.asList(trace2)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("web").addBinaryAnnotation("local", "app").build())).isEmpty();
    }

    @Test
    public void getTraces_binaryAnnotationWithEmptyValue() {
        Span span = Span.builder().traceId(1L).name("call1").id(1L).timestamp(Long.valueOf((this.today + 1L) * 1000L)).addBinaryAnnotation(BinaryAnnotation.create((String)"empty", (String)"", (Endpoint)this.ep)).build();
        this.accept(span);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).containsExactly((Object[])new List[]{Arrays.asList(span)});
        Assertions.assertThat((List)this.store().getTrace(span.traceIdHigh, span.traceId)).containsExactly((Object[])new Span[]{span});
    }

    @Test
    public void getTraces_128BitTraceId() {
        Span span = this.span1.toBuilder().traceIdHigh(1L).build();
        this.accept(span);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().build())).containsExactly((Object[])new List[]{Arrays.asList(span)});
    }

    @Test
    public void getTraces_mergesSpans() {
        this.accept(this.span1, this.span4, this.span5);
        TreeSet mergedAnnotations = new TreeSet(this.span4.annotations);
        mergedAnnotations.addAll(this.span5.annotations);
        Span merged = this.span4.toBuilder().timestamp(Long.valueOf(((Annotation)mergedAnnotations.first()).timestamp)).duration(Long.valueOf(((Annotation)mergedAnnotations.last()).timestamp - ((Annotation)mergedAnnotations.first()).timestamp)).annotations(mergedAnnotations).binaryAnnotations((Collection)this.span5.binaryAnnotations).build();
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").build())).containsExactly((Object[])new List[]{Arrays.asList(merged), Arrays.asList(this.span1)});
    }

    @Test
    public void getTraces_limit() {
        this.accept(this.span1, this.span3);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").limit(Integer.valueOf(1)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3)});
    }

    @Test
    public void getTraces_endTsAndLookback() {
        this.accept(this.span1, this.span3);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 1L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 2L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3), Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 3L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3), Arrays.asList(this.span1)});
    }

    @Test
    public void getTraces_lookback() {
        this.accept(this.span1, this.span3);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 1L)).lookback(Long.valueOf(1L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 2L)).lookback(Long.valueOf(1L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3), Arrays.asList(this.span1)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 3L)).lookback(Long.valueOf(1L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3)});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").endTs(Long.valueOf(this.today + 3L)).lookback(Long.valueOf(2L)).build())).containsExactly((Object[])new List[]{Arrays.asList(this.span3), Arrays.asList(this.span1)});
    }

    @Test
    public void getAllServiceNames_emptyServiceName() {
        this.accept(this.spanEmptyServiceName);
        Assertions.assertThat((List)this.store().getServiceNames()).isEmpty();
    }

    @Test
    public void getSpanNames_emptySpanName() {
        this.accept(this.spanEmptySpanName);
        Assertions.assertThat((List)this.store().getSpanNames(this.spanEmptySpanName.name)).isEmpty();
    }

    @Test
    public void spanNamesGoLowercase() {
        this.accept(this.span1);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service").spanName("MeThOdCaLl").build())).containsOnly((Object[])new List[]{Arrays.asList(this.span1)});
    }

    @Test
    public void serviceNamesGoLowercase() {
        this.accept(this.span1);
        Assertions.assertThat((List)this.store().getSpanNames("SeRvIcE")).containsExactly((Object[])new String[]{"methodcall"});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("SeRvIcE").build())).containsOnly((Object[])new List[]{Arrays.asList(this.span1)});
    }

    @Test
    public void correctsClockSkew() {
        Endpoint client = Endpoint.create((String)"client", (int)-1062731775);
        Endpoint frontend = Endpoint.create((String)"frontend", (int)-1062731774);
        Endpoint backend = Endpoint.create((String)"backend", (int)-1062731773);
        Span parent = Span.builder().traceId(1L).name("method1").id(666L).addAnnotation(Annotation.create((long)((this.today + 100L) * 1000L), (String)"cs", (Endpoint)client)).addAnnotation(Annotation.create((long)((this.today + 95L) * 1000L), (String)"sr", (Endpoint)frontend)).addAnnotation(Annotation.create((long)((this.today + 120L) * 1000L), (String)"ss", (Endpoint)frontend)).addAnnotation(Annotation.create((long)((this.today + 135L) * 1000L), (String)"cr", (Endpoint)client)).build();
        Span remoteChild = Span.builder().traceId(1L).name("method2").id(777L).parentId(Long.valueOf(666L)).addAnnotation(Annotation.create((long)((this.today + 100L) * 1000L), (String)"cs", (Endpoint)frontend)).addAnnotation(Annotation.create((long)((this.today + 115L) * 1000L), (String)"sr", (Endpoint)backend)).addAnnotation(Annotation.create((long)((this.today + 120L) * 1000L), (String)"ss", (Endpoint)backend)).addAnnotation(Annotation.create((long)((this.today + 115L) * 1000L), (String)"cr", (Endpoint)frontend)).build();
        Span localChild = Span.builder().traceId(1L).name("local").id(778L).parentId(Long.valueOf(666L)).timestamp(Long.valueOf((this.today + 101L) * 1000L)).duration(Long.valueOf(50L)).addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"framey", (Endpoint)frontend)).build();
        List<Span> skewed = Arrays.asList(parent, remoteChild, localChild);
        Assertions.assertThat((long)((Annotation)skewed.get((int)0).annotations.get((int)0)).timestamp).isLessThanOrEqualTo(((Annotation)skewed.get((int)1).annotations.get((int)0)).timestamp).isLessThanOrEqualTo((Comparable)skewed.get((int)2).timestamp);
        this.accept(parent, remoteChild, localChild);
        List adjusted = this.store().getTrace(localChild.traceIdHigh, localChild.traceId);
        Assertions.assertThat((Long)((Span)adjusted.get((int)0)).timestamp).isLessThanOrEqualTo((Comparable)((Span)adjusted.get((int)0)).timestamp);
        ((AbstractLongAssert)Assertions.assertThat((Long)((Span)adjusted.get((int)0)).timestamp).isLessThanOrEqualTo((Comparable)((Span)adjusted.get((int)1)).timestamp)).isLessThanOrEqualTo((Comparable)((Span)adjusted.get((int)2)).timestamp);
        Assertions.assertThat((Long)((Span)adjusted.get((int)0)).duration).isEqualTo(SpanStoreTest.clientDuration(skewed.get(0)));
        Assertions.assertThat((Long)((Span)adjusted.get((int)1)).duration).isEqualTo(SpanStoreTest.clientDuration(skewed.get(1)));
        Assertions.assertThat((Long)((Span)adjusted.get((int)2)).duration).isEqualTo((Object)skewed.get((int)2).duration);
    }

    @Test
    public void clientTimestampAndDurationWinInSharedSpan() {
        Endpoint client = Endpoint.create((String)"client", (int)-1062731775);
        Endpoint server = Endpoint.create((String)"server", (int)-1062731774);
        long clientTimestamp = (this.today + 100L) * 1000L;
        long clientDuration = 35000L;
        Span clientView = Span.builder().traceId(1L).name("direct").id(666L).timestamp(Long.valueOf(clientTimestamp)).duration(Long.valueOf(clientDuration)).addAnnotation(Annotation.create((long)((this.today + 100L) * 1000L), (String)"cs", (Endpoint)client)).addAnnotation(Annotation.create((long)((this.today + 135L) * 1000L), (String)"cr", (Endpoint)client)).build();
        Span serverView = Span.builder().traceId(1L).name("direct").id(666L).timestamp(Long.valueOf((this.today + 105L) * 1000L)).duration(Long.valueOf(25000L)).addAnnotation(Annotation.create((long)((this.today + 105L) * 1000L), (String)"sr", (Endpoint)server)).addAnnotation(Annotation.create((long)((this.today + 130L) * 1000L), (String)"ss", (Endpoint)server)).build();
        Span clientViewDerived = Span.builder().traceId(1L).name("derived").id(666L).addAnnotation(Annotation.create((long)clientTimestamp, (String)"cs", (Endpoint)client)).addAnnotation(Annotation.create((long)(clientTimestamp + clientDuration), (String)"cs", (Endpoint)client)).build();
        Span serverViewDerived = Span.builder().traceId(1L).name("derived").id(666L).addAnnotation(Annotation.create((long)((this.today + 105L) * 1000L), (String)"sr", (Endpoint)server)).addAnnotation(Annotation.create((long)((this.today + 130L) * 1000L), (String)"ss", (Endpoint)server)).build();
        this.accept(serverView, serverViewDerived);
        this.accept(clientView, clientViewDerived);
        for (Span span : this.store().getTrace(clientView.traceIdHigh, clientView.traceId)) {
            Assertions.assertThat((Long)span.timestamp).isEqualTo(clientTimestamp);
            Assertions.assertThat((Long)span.duration).isEqualTo(clientDuration);
        }
    }

    @Test
    public void traceWithManySpans() {
        Object[] trace = new Span[101];
        trace[0] = TestObjects.TRACE.get(0);
        IntStream.range(0, 100).forEach(arg_0 -> SpanStoreTest.lambda$traceWithManySpans$1((Span[])trace, arg_0));
        this.accept((Span[])trace);
        String serviceName = ((Annotation)trace[1].annotations.get((int)0)).endpoint.serviceName;
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName(serviceName).build())).containsExactly((Object[])new List[]{Arrays.asList(trace)});
        Assertions.assertThat((List)this.store().getTrace(trace[0].traceIdHigh, trace[0].traceId)).containsExactly(trace);
        Assertions.assertThat((List)this.store().getRawTrace(((Span)trace[0]).traceIdHigh, ((Span)trace[0]).traceId)).containsAll(Arrays.asList(trace));
    }

    @Test
    public void whenSpanTimestampIsMissingClientSendIsPreferred() {
        Endpoint frontend = Endpoint.create((String)"frontend", (int)-1062731774);
        Annotation cs = Annotation.create((long)((this.today + 50L) * 1000L), (String)"cs", (Endpoint)frontend);
        Annotation cr = Annotation.create((long)((this.today + 150L) * 1000L), (String)"cr", (Endpoint)frontend);
        Endpoint backend = Endpoint.create((String)"backend", (int)-1062731774);
        Annotation sr = Annotation.create((long)((this.today + 95L) * 1000L), (String)"sr", (Endpoint)backend);
        Annotation ss = Annotation.create((long)((this.today + 100L) * 1000L), (String)"ss", (Endpoint)backend);
        Span span = Span.builder().traceId(1L).name("method1").id(666L).build();
        this.accept(span.toBuilder().addAnnotation(sr).addAnnotation(ss).build());
        this.accept(span.toBuilder().addAnnotation(cs).addAnnotation(cr).build());
        Assertions.assertThat((List)this.store().getTrace(this.span1.traceIdHigh, span.traceId)).containsExactly((Object[])new Span[]{span.toBuilder().timestamp(Long.valueOf(cs.timestamp)).duration(Long.valueOf(cr.timestamp - cs.timestamp)).annotations(Arrays.asList(cs, sr, ss, cr)).build()});
    }

    @Test
    public void rawTrace_doesntPerformQueryTimeAdjustment() {
        Endpoint producer = Endpoint.create((String)"producer", (int)-1062731775);
        Annotation ms = Annotation.create((long)((this.today + 95L) * 1000L), (String)"ms", (Endpoint)producer);
        Endpoint consumer = Endpoint.create((String)"consumer", (int)-1062731774);
        Annotation mr = Annotation.create((long)((this.today + 100L) * 1000L), (String)"mr", (Endpoint)consumer);
        Span span = Span.builder().traceId(1L).name("message").id(666L).build();
        this.accept(span.toBuilder().addAnnotation(ms).build());
        this.accept(span.toBuilder().addAnnotation(mr).build());
        Assertions.assertThat((List)this.store().getTrace(this.span1.traceIdHigh, span.traceId)).containsExactly((Object[])new Span[]{span.toBuilder().timestamp(Long.valueOf(ms.timestamp)).duration(Long.valueOf(mr.timestamp - ms.timestamp)).annotations(Arrays.asList(ms, mr)).build()});
        for (Span raw : this.store().getRawTrace(this.span1.traceIdHigh, span.traceId)) {
            Assertions.assertThat((Long)raw.timestamp).isNull();
            Assertions.assertThat((Long)raw.duration).isNull();
        }
    }

    @Test
    public void getTraces_acrossServices() {
        List annotations = IntStream.rangeClosed(1, 10).mapToObj(i -> BinaryAnnotation.create((String)"lc", (String)"serviceAnnotation", (Endpoint)Endpoint.create((String)("service" + i), (int)(0x7F000000 | i)))).collect(Collectors.toList());
        long gapBetweenSpans = 100L;
        List<Span> earlySpans = IntStream.rangeClosed(1, 10).mapToObj(i -> Span.builder().name("early").traceId((long)i).id((long)i).timestamp(Long.valueOf((this.today - (long)i) * 1000L)).duration(Long.valueOf(1L)).addBinaryAnnotation((BinaryAnnotation)annotations.get(i - 1)).build()).collect(Collectors.toList());
        List<Span> lateSpans = IntStream.rangeClosed(1, 10).mapToObj(i -> Span.builder().name("late").traceId((long)(i + 10)).id((long)(i + 10)).timestamp(Long.valueOf((this.today + gapBetweenSpans - (long)i) * 1000L)).duration(Long.valueOf(1L)).addBinaryAnnotation((BinaryAnnotation)annotations.get(i - 1)).build()).collect(Collectors.toList());
        this.accept(earlySpans.toArray(new Span[10]));
        this.accept(lateSpans.toArray(new Span[10]));
        Object[] earlyTraces = (List[])earlySpans.stream().map(Collections::singletonList).toArray(List[]::new);
        Object[] lateTraces = (List[])lateSpans.stream().map(Collections::singletonList).toArray(List[]::new);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().serviceName("service1").build())).containsExactly((Object[])new List[]{lateTraces[0], earlyTraces[0]});
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().limit(Integer.valueOf(20)).build())).hasSize(20);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().limit(Integer.valueOf(10)).build())).containsExactly(lateTraces);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().limit(Integer.valueOf(20)).endTs(Long.valueOf(this.today + gapBetweenSpans)).lookback(Long.valueOf(gapBetweenSpans)).build())).containsExactly(lateTraces);
        Assertions.assertThat((List)this.store().getTraces(QueryRequest.builder().limit(Integer.valueOf(20)).endTs(Long.valueOf(this.today)).build())).containsExactly(earlyTraces);
    }

    static long clientDuration(Span span) {
        long[] timestamps = span.annotations.stream().filter(a -> a.value.startsWith("c")).mapToLong(a -> a.timestamp).sorted().toArray();
        return timestamps[1] - timestamps[0];
    }

    private static /* synthetic */ void lambda$traceWithManySpans$1(Span[] trace, int i) {
        Span s = TestObjects.TRACE.get(1);
        trace[i + 1] = s.toBuilder().id(s.id + (long)i).timestamp(Long.valueOf(s.timestamp + (long)i)).annotations((Collection)s.annotations.stream().map(a -> Annotation.create((long)(a.timestamp + (long)i), (String)a.value, (Endpoint)a.endpoint)).collect(Collectors.toList())).build();
    }
}

