/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import zipkin.storage.QueryRequest;

public class QueryRequestTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void serviceNameCanBeNull() {
        Assertions.assertThat((String)QueryRequest.builder().build().serviceName).isNull();
    }

    @Test
    public void serviceNameCantBeEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("serviceName was empty");
        QueryRequest.builder().serviceName("").build();
    }

    @Test
    public void spanNameCantBeEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("spanName was empty");
        QueryRequest.builder().serviceName("foo").spanName("").build();
    }

    @Test
    public void annotationCantBeEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("annotation was empty");
        QueryRequest.builder().serviceName("foo").addAnnotation("").build();
    }

    @Test
    public void annotationCantBeCore() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("queries cannot be refined by core annotations: sr");
        QueryRequest.builder().serviceName("foo").addAnnotation("sr").build();
    }

    @Test
    public void binaryAnnotationKeyCantBeEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("binary annotation key was empty");
        QueryRequest.builder().serviceName("foo").addBinaryAnnotation("", "bar").build();
    }

    @Test
    public void binaryAnnotationValueCantBeEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("binary annotation value for foo was empty");
        QueryRequest.builder().serviceName("foo").addBinaryAnnotation("foo", "").build();
    }

    @Test
    public void endTsMustBePositive() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("endTs should be positive, in epoch microseconds: was 0");
        QueryRequest.builder().serviceName("foo").endTs(Long.valueOf(0L)).build();
    }

    @Test
    public void limitMustBePositive() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("limit should be positive: was 0");
        QueryRequest.builder().serviceName("foo").limit(Integer.valueOf(0)).build();
    }

    @Test
    public void annotationQuery_roundTrip() {
        String annotationQuery = "http.method=GET and error";
        QueryRequest request = QueryRequest.builder().serviceName("security-service").parseAnnotationQuery(annotationQuery).build();
        ((MapAssert)Assertions.assertThat((Map)request.binaryAnnotations).containsEntry((Object)"http.method", (Object)"GET")).hasSize(1);
        Assertions.assertThat((List)request.annotations).containsExactly((Object[])new String[]{"error"});
        Assertions.assertThat((String)request.toAnnotationQuery()).isEqualTo((Object)annotationQuery);
    }

    @Test
    public void annotationQuery_complexValue() {
        String annotationQuery = "http.method=GET=1 and error";
        QueryRequest request = QueryRequest.builder().serviceName("security-service").parseAnnotationQuery(annotationQuery).build();
        ((MapAssert)Assertions.assertThat((Map)request.binaryAnnotations).containsEntry((Object)"http.method", (Object)"GET=1")).hasSize(1);
        Assertions.assertThat((List)request.annotations).containsExactly((Object[])new String[]{"error"});
        Assertions.assertThat((String)request.toAnnotationQuery()).isEqualTo((Object)annotationQuery);
    }

    @Test
    public void annotationQuery_missingValue() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("binary annotation value for http.method was empty");
        String annotationQuery = "http.method=";
        QueryRequest request = QueryRequest.builder().serviceName("security-service").parseAnnotationQuery(annotationQuery).build();
        Assertions.assertThat((List)request.annotations).containsExactly((Object[])new String[]{"http.method"});
    }

    @Test
    public void toAnnotationQueryWhenNoInputIsNull() {
        QueryRequest request = QueryRequest.builder().serviceName("security-service").build();
        Assertions.assertThat((String)request.toAnnotationQuery()).isNull();
    }

    @Test
    public void minDuration_mustBePositive() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("minDuration must be a positive number of microseconds");
        QueryRequest.builder().serviceName("foo").minDuration(Long.valueOf(0L)).build();
    }

    @Test
    public void maxDuration_onlyWithMinDuration() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxDuration is only valid with minDuration");
        QueryRequest.builder().serviceName("foo").maxDuration(Long.valueOf(0L)).build();
    }

    @Test
    public void maxDuration_greaterThanOrEqualToMinDuration() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxDuration should be >= minDuration");
        QueryRequest.builder().serviceName("foo").minDuration(Long.valueOf(1L)).maxDuration(Long.valueOf(0L)).build();
    }
}

