/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import zipkin.TestObjects;
import zipkin.internal.CallbackCaptor;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.InternalBlockingToAsyncSpanStoreAdapter;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;

public class InternalBlockingToAsyncSpanStoreAdapterTest {
    @Rule
    public MockitoRule mocks = MockitoJUnit.rule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private SpanStore spanStore;
    private AsyncSpanStore asyncSpanStore;

    @Before
    public void setUp() {
        this.asyncSpanStore = new InternalBlockingToAsyncSpanStoreAdapter(this.spanStore, Runnable::run);
    }

    @Test
    public void getTraces_success() {
        QueryRequest request = QueryRequest.builder().serviceName("zipkin-ui").build();
        Mockito.when((Object)this.spanStore.getTraces(request)).thenReturn(Arrays.asList(TestObjects.TRACE));
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getTraces(request, (Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(Arrays.asList(TestObjects.TRACE));
    }

    @Test
    public void getTraces_exception() {
        this.thrown.expect(IllegalStateException.class);
        QueryRequest request = QueryRequest.builder().serviceName("service").build();
        Mockito.when((Object)this.spanStore.getTraces(request)).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getTraces(request, (Callback)captor);
        captor.get();
    }

    @Test
    public void getTrace_success() {
        Mockito.when((Object)this.spanStore.getTrace(1L, 2L)).thenReturn(TestObjects.TRACE);
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getTrace(1L, 2L, (Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(TestObjects.TRACE);
    }

    @Test
    public void getTrace_exception() {
        this.thrown.expect(IllegalStateException.class);
        Mockito.when((Object)this.spanStore.getTrace(1L, 2L)).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getTrace(1L, 2L, (Callback)captor);
        captor.get();
    }

    @Test
    public void getRawTrace_success() {
        Mockito.when((Object)this.spanStore.getRawTrace(1L, 2L)).thenReturn(TestObjects.TRACE);
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getRawTrace(1L, 2L, (Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(TestObjects.TRACE);
    }

    @Test
    public void getRawTrace_exception() {
        this.thrown.expect(IllegalStateException.class);
        Mockito.when((Object)this.spanStore.getRawTrace(1L, 2L)).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getRawTrace(1L, 2L, (Callback)captor);
        captor.get();
    }

    @Test
    public void getServiceNames_success() {
        Mockito.when((Object)this.spanStore.getServiceNames()).thenReturn(Arrays.asList("service1"));
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getServiceNames((Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(Arrays.asList("service1"));
    }

    @Test
    public void getServiceNames_exception() {
        this.thrown.expect(IllegalStateException.class);
        Mockito.when((Object)this.spanStore.getServiceNames()).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getServiceNames((Callback)captor);
        captor.get();
    }

    @Test
    public void getSpanNames_success() {
        Mockito.when((Object)this.spanStore.getSpanNames("service1")).thenReturn(Arrays.asList("span1"));
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getSpanNames("service1", (Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(Arrays.asList("span1"));
    }

    @Test
    public void getSpanNames_exception() {
        this.thrown.expect(IllegalStateException.class);
        Mockito.when((Object)this.spanStore.getSpanNames("service1")).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getSpanNames("service1", (Callback)captor);
        captor.get();
    }

    @Test
    public void getDependencies_success() {
        Mockito.when((Object)this.spanStore.getDependencies(1L, null)).thenReturn(TestObjects.LINKS);
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getDependencies(1L, null, (Callback)captor);
        Assertions.assertThat((List)((List)captor.get())).isEqualTo(TestObjects.LINKS);
    }

    @Test
    public void getDependencies_exception() {
        this.thrown.expect(IllegalStateException.class);
        Mockito.when((Object)this.spanStore.getDependencies(1L, null)).thenThrow(new Throwable[]{new IllegalStateException("failed")});
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanStore.getDependencies(1L, null, (Callback)captor);
        captor.get();
    }
}

