/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import zipkin.TestObjects;
import zipkin.internal.CallbackCaptor;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.Callback;
import zipkin.storage.InternalBlockingToAsyncSpanConsumerAdapter;
import zipkin.storage.StorageAdapters;

public class InternalBlockingToAsyncSpanConsumerAdapterTest {
    @Rule
    public MockitoRule mocks = MockitoJUnit.rule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private StorageAdapters.SpanConsumer spanConsumer;
    private AsyncSpanConsumer asyncSpanConsumer;

    @Before
    public void setUp() {
        this.asyncSpanConsumer = new InternalBlockingToAsyncSpanConsumerAdapter(this.spanConsumer, Runnable::run);
    }

    @Test
    public void accept_success() {
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanConsumer.accept(TestObjects.TRACE, (Callback)captor);
        Assertions.assertThat((Object)((Void)captor.get())).isNull();
    }

    @Test
    public void accept_exception() {
        this.thrown.expect(IllegalStateException.class);
        ((StorageAdapters.SpanConsumer)Mockito.doThrow((Throwable)new IllegalStateException("failed")).when((Object)this.spanConsumer)).accept(TestObjects.TRACE);
        CallbackCaptor captor = new CallbackCaptor();
        this.asyncSpanConsumer.accept(TestObjects.TRACE, (Callback)captor);
        captor.get();
    }
}

