/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import zipkin.TestObjects;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.InternalAsyncToBlockingSpanStoreAdapter;
import zipkin.storage.QueryRequest;

public class InternalAsyncToBlockingSpanStoreAdapterTest {
    @Rule
    public MockitoRule mocks = MockitoJUnit.rule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private AsyncSpanStore delegate;
    private InternalAsyncToBlockingSpanStoreAdapter spanStore;

    @Before
    public void setUp() {
        this.spanStore = new InternalAsyncToBlockingSpanStoreAdapter(this.delegate);
    }

    @Test
    public void getTraces_success() {
        QueryRequest request = QueryRequest.builder().serviceName("service").endTs(Long.valueOf(1000L)).build();
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(Arrays.asList(TestObjects.TRACE)))).when((Object)this.delegate)).getTraces((QueryRequest)Matchers.eq((Object)request), (Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getTraces(request)).containsExactly((Object[])new List[]{TestObjects.TRACE});
    }

    @Test
    public void getTraces_exception() {
        QueryRequest request = QueryRequest.builder().serviceName("service").endTs(Long.valueOf(1000L)).build();
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getTraces((QueryRequest)Matchers.eq((Object)request), (Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getTraces(request);
    }

    @Test
    public void getTrace_success() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(TestObjects.TRACE))).when((Object)this.delegate)).getTrace(Matchers.eq((long)1L), Matchers.eq((long)2L), (Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getTrace(1L, 2L)).isEqualTo(TestObjects.TRACE);
    }

    @Test
    public void getTrace_exception() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getTrace(Matchers.eq((long)1L), Matchers.eq((long)2L), (Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getTrace(1L, 2L);
    }

    @Test
    public void getRawTrace_success() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(TestObjects.TRACE))).when((Object)this.delegate)).getRawTrace(Matchers.eq((long)1L), Matchers.eq((long)2L), (Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getRawTrace(1L, 2L)).isEqualTo(TestObjects.TRACE);
    }

    @Test
    public void getRawTrace_exception() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getRawTrace(Matchers.eq((long)1L), Matchers.eq((long)2L), (Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getRawTrace(1L, 2L);
    }

    @Test
    public void getServiceNames_success() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(Arrays.asList("service1", "service2")))).when((Object)this.delegate)).getServiceNames((Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getServiceNames()).containsExactly((Object[])new String[]{"service1", "service2"});
    }

    @Test
    public void getServiceNames_exception() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getServiceNames((Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getServiceNames();
    }

    @Test
    public void getSpanNames_success() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(Arrays.asList("span1", "span2")))).when((Object)this.delegate)).getSpanNames((String)Matchers.eq((Object)"service"), (Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getSpanNames("service")).containsExactly((Object[])new String[]{"span1", "span2"});
    }

    @Test
    public void getSpanNames_exception() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getSpanNames((String)Matchers.eq((Object)"service"), (Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getSpanNames("service");
    }

    @Test
    public void getDependencies_success() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onSuccess(TestObjects.LINKS))).when((Object)this.delegate)).getDependencies(Matchers.eq((long)1L), Long.valueOf(Matchers.eq((long)0L)), (Callback)Matchers.any(Callback.class));
        Assertions.assertThat((List)this.spanStore.getDependencies(1L, Long.valueOf(0L))).containsExactlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void getDependencies_exception() {
        ((AsyncSpanStore)Mockito.doAnswer((Answer)InternalAsyncToBlockingSpanStoreAdapterTest.answer(c -> c.onError((Throwable)new IllegalStateException("failed")))).when((Object)this.delegate)).getDependencies(Matchers.eq((long)1L), Long.valueOf(Matchers.eq((long)0L)), (Callback)Matchers.any(Callback.class));
        this.thrown.expect(IllegalStateException.class);
        this.spanStore.getDependencies(1L, Long.valueOf(0L));
    }

    static <T> Answer answer(Consumer<Callback<T>> onCallback) {
        return invocation -> {
            onCallback.accept((Callback)invocation.getArguments()[invocation.getArguments().length - 1]);
            return null;
        };
    }
}

