/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.CallbackCaptor;
import zipkin.storage.Callback;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

public abstract class DependenciesTest {
    protected abstract StorageComponent storage();

    SpanStore store() {
        return this.storage().spanStore();
    }

    @Before
    public abstract void clear() throws IOException;

    protected void processDependencies(List<Span> spans) {
        CallbackCaptor captor = new CallbackCaptor();
        this.storage().asyncSpanConsumer().accept(spans, (Callback)captor);
        captor.get();
    }

    @Test
    public void getDependencies() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void getDependencies_strictTraceId() {
        ArrayList<Span> mixedTrace = new ArrayList<Span>(TestObjects.TRACE);
        mixedTrace.set(1, TestObjects.TRACE.get(1).toBuilder().traceIdHigh(2L).build());
        this.processDependencies(mixedTrace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void replayOverwrites() {
        this.processDependencies(TestObjects.TRACE);
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void empty() {
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).isEmpty();
    }

    @Test
    public void traceIdIsOpaque() {
        List<Span> differentTraceId = TestObjects.TRACE.stream().map(s -> s.toBuilder().traceId(Long.MAX_VALUE).build()).collect(Collectors.toList());
        this.processDependencies(differentTraceId);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void getDependenciesAllInstrumented() {
        Endpoint one = Endpoint.create((String)"trace-producer-one", (int)2130706433);
        Endpoint onePort3001 = one.toBuilder().port(3001).build();
        Endpoint two = Endpoint.create((String)"trace-producer-two", (int)2130706434);
        Endpoint twoPort3002 = two.toBuilder().port(3002).build();
        Endpoint three = Endpoint.create((String)"trace-producer-three", (int)2130706435);
        List<Span> trace = Arrays.asList(Span.builder().traceId(10L).id(10L).name("get").timestamp(Long.valueOf(1445136539256150L)).duration(Long.valueOf(1152579L)).addAnnotation(Annotation.create((long)1445136539256150L, (String)"sr", (Endpoint)one)).addAnnotation(Annotation.create((long)1445136540408729L, (String)"ss", (Endpoint)one)).build(), Span.builder().traceId(10L).parentId(Long.valueOf(10L)).id(20L).name("get").timestamp(Long.valueOf(1445136539764798L)).duration(Long.valueOf(639337L)).addAnnotation(Annotation.create((long)1445136539764798L, (String)"cs", (Endpoint)onePort3001)).addAnnotation(Annotation.create((long)1445136539816432L, (String)"sr", (Endpoint)two)).addAnnotation(Annotation.create((long)1445136540401414L, (String)"ss", (Endpoint)two)).addAnnotation(Annotation.create((long)1445136540404135L, (String)"cr", (Endpoint)onePort3001)).build(), Span.builder().traceId(10L).parentId(Long.valueOf(20L)).id(30L).name("get").timestamp(Long.valueOf(1445136540025751L)).duration(Long.valueOf(371298L)).addAnnotation(Annotation.create((long)1445136540025751L, (String)"cs", (Endpoint)twoPort3002)).addAnnotation(Annotation.create((long)1445136540072846L, (String)"sr", (Endpoint)three)).addAnnotation(Annotation.create((long)1445136540394644L, (String)"ss", (Endpoint)three)).addAnnotation(Annotation.create((long)1445136540397049L, (String)"cr", (Endpoint)twoPort3002)).build());
        this.processDependencies(trace);
        long traceDuration = trace.get((int)0).duration;
        Assertions.assertThat((List)this.store().getDependencies((trace.get((int)0).timestamp + traceDuration) / 1000L, Long.valueOf(traceDuration / 1000L))).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"trace-producer-one", (String)"trace-producer-two", (long)1L), DependencyLink.create((String)"trace-producer-two", (String)"trace-producer-three", (long)1L)});
    }

    @Test
    public void getDependencies_noTimestamps() {
        Endpoint one = Endpoint.create((String)"trace-producer-one", (int)2130706433);
        Endpoint onePort3001 = one.toBuilder().port(3001).build();
        Endpoint two = Endpoint.create((String)"trace-producer-two", (int)2130706434);
        Endpoint twoPort3002 = two.toBuilder().port(3002).build();
        Endpoint three = Endpoint.create((String)"trace-producer-three", (int)2130706435);
        List<Span> trace = Arrays.asList(Span.builder().traceId(10L).id(10L).name("get").addAnnotation(Annotation.create((long)1445136539256150L, (String)"sr", (Endpoint)one)).addAnnotation(Annotation.create((long)1445136540408729L, (String)"ss", (Endpoint)one)).build(), Span.builder().traceId(10L).parentId(Long.valueOf(10L)).id(20L).name("get").addAnnotation(Annotation.create((long)1445136539764798L, (String)"cs", (Endpoint)onePort3001)).addAnnotation(Annotation.create((long)1445136539816432L, (String)"sr", (Endpoint)two)).addAnnotation(Annotation.create((long)1445136540401414L, (String)"ss", (Endpoint)two)).addAnnotation(Annotation.create((long)1445136540404135L, (String)"cr", (Endpoint)onePort3001)).build(), Span.builder().traceId(10L).parentId(Long.valueOf(20L)).id(30L).name("get").addAnnotation(Annotation.create((long)1445136540025751L, (String)"cs", (Endpoint)twoPort3002)).addAnnotation(Annotation.create((long)1445136540072846L, (String)"sr", (Endpoint)three)).addAnnotation(Annotation.create((long)1445136540394644L, (String)"ss", (Endpoint)three)).addAnnotation(Annotation.create((long)1445136540397049L, (String)"cr", (Endpoint)twoPort3002)).build());
        this.processDependencies(trace);
        long traceDuration = ApplyTimestampAndDuration.apply((Span)trace.get((int)0)).duration;
        Assertions.assertThat((List)this.store().getDependencies((((Annotation)trace.get((int)0).annotations.get((int)0)).timestamp + traceDuration) / 1000L, Long.valueOf(traceDuration / 1000L))).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"trace-producer-one", (String)"trace-producer-two", (long)1L), DependencyLink.create((String)"trace-producer-two", (String)"trace-producer-three", (long)1L)});
    }

    @Test
    public void getDependenciesMultiLevel() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void dependencies_loopback() {
        List<Span> traceWithLoopback = Arrays.asList(TestObjects.TRACE.get(0), TestObjects.TRACE.get(1).toBuilder().annotations((Collection)TestObjects.TRACE.get((int)1).annotations.stream().map(a -> Annotation.create((long)a.timestamp, (String)a.value, (Endpoint)TestObjects.WEB_ENDPOINT)).collect(Collectors.toList())).binaryAnnotations(Arrays.asList(new BinaryAnnotation[0])).build());
        this.processDependencies(traceWithLoopback);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"web", (long)1L)});
    }

    @Test
    public void dependencies_headlessTrace() {
        this.processDependencies(Arrays.asList(TestObjects.TRACE.get(1), TestObjects.TRACE.get(2)));
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void looksBackIndefinitely() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void insideTheInterval() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.DEPENDENCIES.endTs, Long.valueOf(TestObjects.DEPENDENCIES.endTs - TestObjects.DEPENDENCIES.startTs))).containsOnlyElementsOf(TestObjects.LINKS);
    }

    @Test
    public void endTimeBeforeData() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY - TestObjects.DAY, null)).isEmpty();
    }

    @Test
    public void lookbackAfterData() {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 2L * TestObjects.DAY, Long.valueOf(TestObjects.DAY))).isEmpty();
    }

    @Test
    public void notInstrumentedClientAndServer() {
        Endpoint someClient = Endpoint.create((String)"some-client", (int)-1408172028);
        List<Span> trace = Arrays.asList(Span.builder().traceId(20L).id(20L).name("get").timestamp(Long.valueOf(TestObjects.TODAY * 1000L)).duration(Long.valueOf(350000L)).addAnnotation(Annotation.create((long)(TestObjects.TODAY * 1000L), (String)"sr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 350L) * 1000L), (String)"ss", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)someClient)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(20L)).id(21L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).duration(Long.valueOf(250000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 50L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 100L) * 1000L), (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 250L) * 1000L), (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 300L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(21L)).id(22L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 150L) * 1000L)).duration(Long.valueOf(50000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 150L) * 1000L), (String)"cs", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 200L) * 1000L), (String)"cr", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.DB_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"some-client", (String)"web", (long)1L), DependencyLink.create((String)"web", (String)"app", (long)1L), DependencyLink.create((String)"app", (String)"db", (long)1L)});
    }

    @Test
    public void instrumentedClientAndServer() {
        List<Span> trace = Arrays.asList(Span.builder().traceId(10L).id(10L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).duration(Long.valueOf(250000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 50L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 100L) * 1000L), (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 250L) * 1000L), (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 300L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(10L).parentId(Long.valueOf(10L)).id(11L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 150L) * 1000L)).duration(Long.valueOf(50000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 150L) * 1000L), (String)"cs", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 200L) * 1000L), (String)"cr", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.DB_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L), DependencyLink.create((String)"app", (String)"db", (long)1L)});
    }

    @Test
    public void noClientSendAddrAnnotations() {
        List<Span> trace = Arrays.asList(Span.builder().traceId(20L).id(20L).name("get").timestamp(Long.valueOf(TestObjects.TODAY * 1000L)).duration(Long.valueOf(350000L)).addAnnotation(Annotation.create((long)(TestObjects.TODAY * 1000L), (String)"sr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 350L) * 1000L), (String)"ss", (Endpoint)TestObjects.WEB_ENDPOINT)).binaryAnnotations(Arrays.asList(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.WEB_ENDPOINT), BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.WEB_ENDPOINT))).build(), Span.builder().traceId(20L).parentId(Long.valueOf(20L)).id(21L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 150L) * 1000L)).duration(Long.valueOf(50000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 150L) * 1000L), (String)"cs", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 200L) * 1000L), (String)"cr", (Endpoint)TestObjects.APP_ENDPOINT)).binaryAnnotations(Arrays.asList(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT), BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.APP_ENDPOINT))).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L)});
    }

    @Test
    public void canSearchForIntervalsBesidesToday() {
        this.processDependencies(this.subtractDay(TestObjects.TRACE));
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.DEPENDENCIES.endTs, Long.valueOf(TestObjects.DEPENDENCIES.endTs - TestObjects.DEPENDENCIES.startTs))).containsOnlyElementsOf(TestObjects.LINKS);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.DEPENDENCIES.endTs - TestObjects.DAY, Long.valueOf(TestObjects.DEPENDENCIES.endTs - TestObjects.DEPENDENCIES.startTs))).containsOnlyElementsOf(TestObjects.LINKS);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.DEPENDENCIES.endTs, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)2L), DependencyLink.create((String)"app", (String)"db", (long)2L)});
    }

    @Test
    public void noCoreAnnotations() {
        Endpoint someClient = Endpoint.create((String)"some-client", (int)-1408172028);
        List<Span> trace = Arrays.asList(Span.builder().traceId(20L).id(20L).name("get").timestamp(Long.valueOf(TestObjects.TODAY * 1000L)).duration(Long.valueOf(350000L)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)someClient)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(20L)).id(21L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).duration(Long.valueOf(250000L)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(21L)).id(22L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 150L) * 1000L)).duration(Long.valueOf(50000L)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.DB_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"some-client", (String)"web", (long)1L), DependencyLink.create((String)"web", (String)"app", (long)1L), DependencyLink.create((String)"app", (String)"db", (long)1L)});
    }

    @Test
    public void intermediateSpans() {
        List<Span> trace = Arrays.asList(Span.builder().traceId(20L).id(20L).name("get").timestamp(Long.valueOf(TestObjects.TODAY * 1000L)).duration(Long.valueOf(350000L)).addAnnotation(Annotation.create((long)(TestObjects.TODAY * 1000L), (String)"sr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 350L) * 1000L), (String)"ss", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(20L)).id(21L).name("call").timestamp(Long.valueOf((TestObjects.TODAY + 25L) * 1000L)).duration(Long.valueOf(325000L)).addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"depth2", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(21L)).id(22L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).duration(Long.valueOf(250000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 50L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 100L) * 1000L), (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 250L) * 1000L), (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 300L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(22L)).id(23L).name("call").timestamp(Long.valueOf((TestObjects.TODAY + 110L) * 1000L)).duration(Long.valueOf(130000L)).addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"depth4", (Endpoint)TestObjects.APP_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(23L)).id(24L).name("call").timestamp(Long.valueOf((TestObjects.TODAY + 125L) * 1000L)).duration(Long.valueOf(105000L)).addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"depth5", (Endpoint)TestObjects.APP_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(24L)).id(25L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 150L) * 1000L)).duration(Long.valueOf(50000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 150L) * 1000L), (String)"cs", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 200L) * 1000L), (String)"cr", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.DB_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L), DependencyLink.create((String)"app", (String)"db", (long)1L)});
    }

    @Test
    public void duplicateAddress() {
        List<Span> trace = Arrays.asList(Span.builder().traceId(20L).id(20L).name("get").timestamp(Long.valueOf(TestObjects.TODAY * 1000L)).duration(Long.valueOf(350000L)).addAnnotation(Annotation.create((long)(TestObjects.TODAY * 1000L), (String)"sr", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 350L) * 1000L), (String)"ss", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(20L).parentId(Long.valueOf(21L)).id(22L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).duration(Long.valueOf(250000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 50L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 300L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L)});
    }

    @Test
    public void unmergedSpans() {
        List<Span> trace = Arrays.asList(Span.builder().traceId(1L).parentId(Long.valueOf(1L)).id(2L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 100L) * 1000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 100L) * 1000L), (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 250L) * 1000L), (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)TestObjects.WEB_ENDPOINT)).build(), Span.builder().traceId(1L).parentId(Long.valueOf(1L)).id(2L).name("get").timestamp(Long.valueOf((TestObjects.TODAY + 50L) * 1000L)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 50L) * 1000L), (String)"cs", (Endpoint)TestObjects.WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TestObjects.TODAY + 300L) * 1000L), (String)"cr", (Endpoint)TestObjects.WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT)).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)this.store().getDependencies(TestObjects.TODAY + 1000L, null)).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L)});
    }

    List<Span> subtractDay(List<Span> trace) {
        return trace.stream().map(s -> s.toBuilder().traceId(s.traceId + 100L).parentId(s.parentId != null ? Long.valueOf(s.parentId + 100L) : null).id(s.id + 100L).timestamp(s.timestamp != null ? Long.valueOf(s.timestamp - TestObjects.DAY * 1000L) : null).annotations((Collection)s.annotations.stream().map(a -> Annotation.create((long)(a.timestamp - TestObjects.DAY * 1000L), (String)a.value, (Endpoint)a.endpoint)).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }
}

