/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import zipkin.internal.Util;

public class UtilTest {
    @Test
    public void equalTest() {
        Assert.assertTrue((boolean)Util.equal(null, null));
        Assert.assertTrue((boolean)Util.equal((Object)"1", (Object)"1"));
        Assert.assertFalse((boolean)Util.equal(null, (Object)"1"));
        Assert.assertFalse((boolean)Util.equal((Object)"1", null));
        Assert.assertFalse((boolean)Util.equal((Object)"1", (Object)"2"));
    }

    @Test
    public void midnightUTCTest() throws ParseException {
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = iso8601.parse("2011-04-15T20:08:18Z");
        long midnight = Util.midnightUTC((long)date.getTime());
        Assertions.assertThat((String)iso8601.format(new Date(midnight))).isEqualTo((Object)"2011-04-15T00:00:00Z");
    }

    @Test
    public void lowerHexToUnsignedLong_downgrades128bitIdsByDroppingHighBits() {
        Assertions.assertThat((long)Util.lowerHexToUnsignedLong((String)"463ac35c9f6413ad48485a3953bb6124")).isEqualTo(Util.lowerHexToUnsignedLong((String)"48485a3953bb6124"));
    }

    @Test
    public void lowerHexToUnsignedLongTest() {
        Assertions.assertThat((long)Util.lowerHexToUnsignedLong((String)"ffffffffffffffff")).isEqualTo(-1L);
        Assertions.assertThat((long)Util.lowerHexToUnsignedLong((String)"0")).isEqualTo(0L);
        Assertions.assertThat((long)Util.lowerHexToUnsignedLong((String)Long.toHexString(Long.MAX_VALUE))).isEqualTo(Long.MAX_VALUE);
        try {
            Util.lowerHexToUnsignedLong((String)"fffffffffffffffffffffffffffffffff");
            Assertions.failBecauseExceptionWasNotThrown(NumberFormatException.class);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Util.lowerHexToUnsignedLong((String)"");
            Assertions.failBecauseExceptionWasNotThrown(NumberFormatException.class);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Util.lowerHexToUnsignedLong((String)"rs");
            Assertions.failBecauseExceptionWasNotThrown(NumberFormatException.class);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void toLowerHex_minValue() {
        Assertions.assertThat((String)Util.toLowerHex((long)Long.MAX_VALUE)).isEqualTo((Object)"7fffffffffffffff");
    }

    @Test
    public void toLowerHex_midValue() {
        Assertions.assertThat((String)Util.toLowerHex((long)3405691582L)).isEqualTo((Object)"00000000cafebabe");
    }

    @Test
    public void toLowerHex_fixedLength() {
        Assertions.assertThat((String)Util.toLowerHex((long)0L)).isEqualTo((Object)"0000000000000000");
    }

    @Test
    public void toLowerHex_whenNotHigh_16Chars() {
        Assertions.assertThat((String)Util.toLowerHex((long)0L, (long)12345678L)).hasToString("0000000000bc614e");
    }

    @Test
    public void toLowerHex_whenHigh_32Chars() {
        Assertions.assertThat((String)Util.toLowerHex((long)1234L, (long)5678L)).hasToString("00000000000004d2000000000000162e");
    }
}

