/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.CodecTest;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.ThriftCodec;

public final class ThriftCodecTest
extends CodecTest {
    private final ThriftCodec codec = new ThriftCodec();

    protected ThriftCodec codec() {
        return this.codec;
    }

    @Test
    public void readSpanFromByteBuffer() throws IOException {
        for (Span span : TestObjects.TRACE) {
            byte[] bytes = this.codec().writeSpan(span);
            Assertions.assertThat((Comparable)this.codec().readSpan(ByteBuffer.wrap(bytes))).isEqualTo((Object)span);
        }
    }

    @Test
    public void sizeInBytes_span() throws IOException {
        Span span = TestObjects.LOTS_OF_SPANS[0];
        Assertions.assertThat((int)ThriftCodec.SPAN_ADAPTER.sizeInBytes((Object)span)).isEqualTo(this.codec().writeSpan(span).length);
    }

    @Test
    public void sizeInBytes_trace() throws IOException {
        Assertions.assertThat((int)ThriftCodec.SPANS_ADAPTER.sizeInBytes(TestObjects.TRACE)).isEqualTo(this.codec().writeSpans(TestObjects.TRACE).length);
    }

    @Test
    public void sizeInBytes_links() throws IOException {
        Assertions.assertThat((int)ThriftCodec.DEPENDENCY_LINKS_ADAPTER.sizeInBytes(TestObjects.LINKS)).isEqualTo(this.codec().writeDependencyLinks(TestObjects.LINKS).length);
    }

    @Test
    public void readDependencyLinksFromByteBuffer() throws IOException {
        List<DependencyLink> links = Arrays.asList(DependencyLink.create((String)"foo", (String)"bar", (long)2L), DependencyLink.create((String)"bar", (String)"baz", (long)3L));
        byte[] bytes = this.codec().writeDependencyLinks(links);
        Assertions.assertThat((List)this.codec().readDependencyLinks(ByteBuffer.wrap(bytes))).isEqualTo(links);
    }
}

