/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import zipkin.internal.PeekingIterator;

public class PeekingIteratorTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void unmodifiable() {
        this.thrown.expect(UnsupportedOperationException.class);
        PeekingIterator<Boolean> it = TrueThenDone.INSTANCE.iterator();
        Assertions.assertThat(it).containsExactly((Object[])new Boolean[]{true});
        it.remove();
    }

    @Test
    public void next() {
        this.thrown.expect(NoSuchElementException.class);
        PeekingIterator<Boolean> it = TrueThenDone.INSTANCE.iterator();
        Assertions.assertThat(it).containsExactly((Object[])new Boolean[]{true});
        it.next();
    }

    @Test
    public void peek() {
        this.thrown.expect(NoSuchElementException.class);
        PeekingIterator<Boolean> it = TrueThenDone.INSTANCE.iterator();
        Assert.assertTrue((boolean)((Boolean)it.peek()));
        Assertions.assertThat(it).containsExactly((Object[])new Boolean[]{true});
        it.peek();
    }

    static enum TrueThenDone implements Iterable<Boolean>
    {
        INSTANCE;


        @Override
        public PeekingIterator<Boolean> iterator() {
            return new PeekingIterator((Iterator)new Iterator<Boolean>(){
                boolean val = true;

                @Override
                public boolean hasNext() {
                    return this.val;
                }

                @Override
                public Boolean next() {
                    if (this.val) {
                        this.val = false;
                        return true;
                    }
                    return false;
                }
            });
        }
    }
}

