/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.Node;

public class NodeTest {
    @Test
    public void traversesBreadthFirst() {
        Node a = new Node().value((Object)Character.valueOf('a'));
        Node b = new Node().value((Object)Character.valueOf('b'));
        Node c = new Node().value((Object)Character.valueOf('c'));
        Node d = new Node().value((Object)Character.valueOf('d'));
        a.addChild(b).addChild(c).addChild(d);
        Node e = new Node().value((Object)Character.valueOf('e'));
        Node f = new Node().value((Object)Character.valueOf('f'));
        Node g = new Node().value((Object)Character.valueOf('g'));
        b.addChild(e).addChild(f).addChild(g);
        Node h = new Node().value((Object)Character.valueOf('h'));
        g.addChild(h);
        Assertions.assertThat((Iterator)a.traverse()).extracting(Node::value).containsExactly((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h')});
    }

    @Test
    public void constructsTraceTree() {
        ArrayList<Span> copy = new ArrayList<Span>(TestObjects.TRACE);
        Collections.shuffle(copy);
        Node root = Node.constructTree(copy);
        Assertions.assertThat((Comparable)((Span)root.value())).isEqualTo((Object)TestObjects.TRACE.get(0));
        Assertions.assertThat((Iterable)root.children()).extracting(Node::value).containsExactly((Object[])new Span[]{TestObjects.TRACE.get(1)});
        Node child = (Node)root.children().iterator().next();
        Assertions.assertThat((Iterable)child.children()).extracting(Node::value).containsExactly((Object[])new Span[]{TestObjects.TRACE.get(2)});
    }
}

