/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.internal.Lazy;

public class LazyTest {
    @Test(timeout=1000L)
    public void get_memoizes() throws InterruptedException {
        int getCount = 1000;
        AtomicInteger value = new AtomicInteger();
        Lazy<Integer> lazyInt = new Lazy<Integer>(){
            final AtomicInteger val = new AtomicInteger();

            protected Integer compute() {
                return this.val.incrementAndGet();
            }
        };
        CountDownLatch latch = new CountDownLatch(getCount);
        ExecutorService exec = Executors.newFixedThreadPool(10);
        for (int i = 0; i < getCount; ++i) {
            exec.execute(() -> LazyTest.lambda$get_memoizes$0(value, (Lazy)lazyInt, latch));
        }
        latch.await();
        Assertions.assertThat((int)value.get()).isEqualTo(getCount);
    }

    private static /* synthetic */ void lambda$get_memoizes$0(AtomicInteger value, Lazy lazyInt, CountDownLatch latch) {
        value.getAndAdd((Integer)lazyInt.get());
        latch.countDown();
    }
}

