/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.internal.Lazy;
import zipkin.internal.LazyCloseable;

public class LazyCloseableTest {
    AtomicInteger callCount = new AtomicInteger();
    TestLazyCloseable<Closeable> alwaysThrow = TestLazyCloseable.create(() -> {
        this.callCount.incrementAndGet();
        throw new RuntimeException();
    });
    TestLazyCloseable<Closeable> throwOnce = TestLazyCloseable.create(() -> {
        if (this.callCount.incrementAndGet() == 1) {
            throw new RuntimeException();
        }
        return () -> {};
    });

    @Test
    public void expiresExceptionWhenDurationPasses() throws InterruptedException {
        this.throwOnce.nanoTime = 0L;
        this.expectExceptionOnGet((Lazy<?>)this.throwOnce);
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(1);
        this.throwOnce.nanoTime = TimeUnit.SECONDS.toNanos(1L);
        Assertions.assertThat((Object)((Closeable)this.throwOnce.get())).isNotNull();
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(2);
        Assertions.assertThat((Object)((Closeable)this.throwOnce.get())).isNotNull();
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(2);
    }

    @Test(timeout=2000L)
    public void exception_memoizes() throws InterruptedException {
        LazyCloseable<Closeable> alwaysThrow = new LazyCloseable<Closeable>(){

            protected Closeable compute() {
                throw new RuntimeException(String.valueOf(LazyCloseableTest.this.callCount.incrementAndGet()));
            }
        };
        int getCount = 1000;
        CountDownLatch latch = new CountDownLatch(getCount);
        ExecutorService exec = Executors.newFixedThreadPool(10);
        for (int i = 0; i < getCount; ++i) {
            exec.execute(() -> this.lambda$exception_memoizes$3((LazyCloseable)alwaysThrow, latch));
        }
        latch.await();
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(1);
        Thread.sleep(1000L);
        this.expectExceptionOnGet((Lazy<?>)alwaysThrow);
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(2);
    }

    @Test
    public void expiresExceptionWhenDurationPasses_initiallyNegative() throws InterruptedException {
        this.alwaysThrow.nanoTime = -TimeUnit.SECONDS.toNanos(1L);
        this.expectExceptionOnGet((Lazy<?>)this.alwaysThrow);
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(1);
        this.alwaysThrow.nanoTime = 0L;
        this.expectExceptionOnGet((Lazy<?>)this.alwaysThrow);
        Assertions.assertThat((int)this.callCount.get()).isEqualTo(2);
    }

    void expectExceptionOnGet(Lazy<?> alwaysThrow) {
        try {
            alwaysThrow.get();
            Assertions.failBecauseExceptionWasNotThrown(RuntimeException.class);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private /* synthetic */ void lambda$exception_memoizes$3(LazyCloseable alwaysThrow, CountDownLatch latch) {
        this.expectExceptionOnGet((Lazy<?>)alwaysThrow);
        latch.countDown();
    }

    static class TestLazyCloseable<T>
    extends LazyCloseable<T> {
        final Supplier<T> delegate;
        long nanoTime;

        static <T> TestLazyCloseable<T> create(Supplier<T> delegate) {
            return new TestLazyCloseable<T>(delegate);
        }

        protected TestLazyCloseable(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        long nanoTime() {
            return this.nanoTime;
        }

        protected T compute() {
            return this.delegate.get();
        }
    }
}

