/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.CodecTest;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.Buffer;
import zipkin.internal.JsonCodec;
import zipkin.internal.Util;

public final class JsonCodecTest
extends CodecTest {
    protected JsonCodec codec() {
        return Codec.JSON;
    }

    @Test
    public void tracesRoundTrip() throws IOException {
        List<List> traces = Arrays.asList(TestObjects.TRACE, TestObjects.TRACE);
        byte[] bytes = this.codec().writeTraces(traces);
        Assertions.assertThat((List)this.codec().readTraces(bytes)).isEqualTo(traces);
    }

    @Test
    public void stringsRoundTrip() throws IOException {
        List<String> strings = Arrays.asList("foo", "bar", "baz");
        byte[] bytes = this.codec().writeStrings(strings);
        Assertions.assertThat((List)this.codec().readStrings(bytes)).isEqualTo(strings);
    }

    @Test
    public void writesTraceIdHighIntoTraceIdField() {
        Span with128BitTraceId = Span.builder().traceIdHigh(Util.lowerHexToUnsignedLong((String)"48485a3953bb6124")).traceId(Util.lowerHexToUnsignedLong((String)"6b221d5bc9e6496c")).id(1L).name("").build();
        Assertions.assertThat((String)new String(Codec.JSON.writeSpan(with128BitTraceId), Util.UTF_8)).startsWith((CharSequence)"{\"traceId\":\"48485a3953bb61246b221d5bc9e6496c\"");
    }

    @Test
    public void readsTraceIdHighFromTraceIdField() {
        byte[] with128BitTraceId = "{\n  \"traceId\": \"48485a3953bb61246b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\"\n}".getBytes(Util.UTF_8);
        byte[] withLower64bitsTraceId = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\"\n}".getBytes(Util.UTF_8);
        Assertions.assertThat((Comparable)Codec.JSON.readSpan(with128BitTraceId)).isEqualTo((Object)Codec.JSON.readSpan(withLower64bitsTraceId).toBuilder().traceIdHigh(Util.lowerHexToUnsignedLong((String)"48485a3953bb6124")).build());
    }

    @Test
    public void ignoreNull_parentId() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"parentId\": null\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void ignoreNull_timestamp() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"timestamp\": null\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void ignoreNull_duration() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"duration\": null\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void ignoreNull_debug() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"debug\": null\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void ignoreNull_annotation_endpoint() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"annotations\": [\n    {\n      \"timestamp\": 1461750491274000,\n      \"value\": \"cs\",\n      \"endpoint\": null\n    }\n  ]\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void ignoreNull_binaryAnnotation_endpoint() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"binaryAnnotations\": [\n    {\n      \"key\": \"lc\",\n      \"value\": \"JDBCSpanStore\",\n      \"endpoint\": null\n    }\n  ]\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void niceErrorOnNull_traceId() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Expected a string but was NULL");
        String json = "{\n  \"traceId\": null,\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\"\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Test
    public void doesntStackOverflowOnToBufferWriterBug_lessThanBytes() {
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Bug found using FooWriter to write Foo as json. Wrote 1/2 bytes: a");
        class Foo {
            Foo() {
            }

            public String toString() {
                class FooWriter
                implements Buffer.Writer {
                    FooWriter() {
                    }

                    public int sizeInBytes(Object value) {
                        return 2;
                    }

                    public void write(Object value, Buffer buffer) {
                        buffer.writeByte(97);
                        throw new RuntimeException("buggy");
                    }
                }
                return new String(JsonCodec.write((Buffer.Writer)new FooWriter(), (Object)this), Util.UTF_8);
            }
        }
        new Foo().toString();
    }

    @Test
    public void doesntStackOverflowOnToBufferWriterBug_Overflow() {
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Bug found using FooWriter to write Foo as json. Wrote 2/2 bytes: ab");
        class Foo {
            Foo() {
            }

            public String toString() {
                class FooWriter
                implements Buffer.Writer {
                    FooWriter() {
                    }

                    public int sizeInBytes(Object value) {
                        return 2;
                    }

                    public void write(Object value, Buffer buffer) {
                        buffer.writeByte(97).writeByte(98).writeByte(99);
                    }
                }
                return new String(JsonCodec.write((Buffer.Writer)new FooWriter(), (Object)this), Util.UTF_8);
            }
        }
        new Foo().toString();
    }

    @Test
    public void niceErrorOnNull_id() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Expected a string but was NULL");
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": null\n}";
        Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
    }

    @Override
    @Test
    public void binaryAnnotation_long() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"binaryAnnotations\": [\n    {\n      \"key\": \"num\",\n      \"value\": 123456789,\n      \"type\": \"I64\"\n    }\n  ]\n}";
        Span span = Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
        Assertions.assertThat((List)span.binaryAnnotations).containsExactly((Object[])new BinaryAnnotation[]{BinaryAnnotation.builder().key("num").type(BinaryAnnotation.Type.I64).value(JsonCodecTest.toBytes(123456789L)).build()});
        Assertions.assertThat((Comparable)Codec.JSON.readSpan(Codec.JSON.writeSpan(span))).isEqualTo((Object)span);
    }

    @Test
    public void binaryAnnotation_long_max() {
        String json = "{  \"traceId\": \"6b221d5bc9e6496c\",  \"id\": \"6b221d5bc9e6496c\",  \"name\": \"get-traces\",  \"binaryAnnotations\": [    {      \"key\": \"num\",      \"value\": \"9223372036854775807\",      \"type\": \"I64\"    }  ]}".replaceAll("\\s", "");
        Span span = Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
        Assertions.assertThat((String)new String(Codec.JSON.writeSpan(span), Util.UTF_8)).isEqualTo((Object)json);
    }

    @Override
    @Test
    public void binaryAnnotation_double() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"binaryAnnotations\": [\n    {\n      \"key\": \"num\",\n      \"value\": 1.23456789,\n      \"type\": \"DOUBLE\"\n    }\n  ]\n}";
        Span span = Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
        Assertions.assertThat((List)span.binaryAnnotations).containsExactly((Object[])new BinaryAnnotation[]{BinaryAnnotation.builder().key("num").type(BinaryAnnotation.Type.DOUBLE).value(JsonCodecTest.toBytes(Double.doubleToRawLongBits(1.23456789))).build()});
        Assertions.assertThat((Comparable)Codec.JSON.readSpan(Codec.JSON.writeSpan(span))).isEqualTo((Object)span);
    }

    @Test
    public void endpointHighPort() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"binaryAnnotations\": [\n    {\n      \"key\": \"foo\",\n      \"value\": \"bar\",\n      \"endpoint\": {\n        \"serviceName\": \"service\",\n        \"port\": 65535\n      }\n    }\n  ]\n}";
        Span span = Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
        Assertions.assertThat((List)span.binaryAnnotations).containsExactly((Object[])new BinaryAnnotation[]{BinaryAnnotation.create((String)"foo", (String)"bar", (Endpoint)Endpoint.builder().serviceName("service").port(65535).build())});
        Assertions.assertThat((Comparable)Codec.JSON.readSpan(Codec.JSON.writeSpan(span))).isEqualTo((Object)span);
    }

    @Test
    public void mappedIPv6toIPv4() {
        String json = "{\n  \"traceId\": \"6b221d5bc9e6496c\",\n  \"name\": \"get-traces\",\n  \"id\": \"6b221d5bc9e6496c\",\n  \"binaryAnnotations\": [\n    {\n      \"key\": \"foo\",\n      \"value\": \"bar\",\n      \"endpoint\": {\n        \"serviceName\": \"service\",\n        \"port\": 65535,\n        \"ipv6\": \"::ffff:192.0.2.128\"\n      }\n    }\n  ]\n}";
        Span span = Codec.JSON.readSpan(json.getBytes(Util.UTF_8));
        Assertions.assertThat((byte[])((BinaryAnnotation)span.binaryAnnotations.get((int)0)).endpoint.ipv6).isNull();
        Assertions.assertThat((int)((BinaryAnnotation)span.binaryAnnotations.get((int)0)).endpoint.ipv4).isEqualTo(-1073741184);
    }

    @Test
    public void sizeInBytes_span() throws IOException {
        Span span = TestObjects.LOTS_OF_SPANS[0];
        Assertions.assertThat((int)JsonCodec.SPAN_ADAPTER.sizeInBytes((Object)span)).isEqualTo(this.codec().writeSpan(span).length);
    }

    @Test
    public void sizeInBytes_link() throws IOException {
        Assertions.assertThat((int)JsonCodec.DEPENDENCY_LINK_ADAPTER.sizeInBytes((Object)TestObjects.LINKS.get(0))).isEqualTo(this.codec().writeDependencyLink(TestObjects.LINKS.get(0)).length);
    }

    static byte[] toBytes(long v) {
        okio.Buffer buffer = new okio.Buffer();
        buffer.writeLong(v);
        return buffer.readByteArray();
    }
}

