/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;

public class GroupByTraceIdTest {
    @Test
    public void sortsDescending() {
        Span span1 = TestObjects.LOTS_OF_SPANS[0].toBuilder().timestamp(Long.valueOf(1L)).build();
        Span span2 = TestObjects.LOTS_OF_SPANS[1].toBuilder().timestamp(Long.valueOf(2L)).build();
        Assertions.assertThat((List)GroupByTraceId.apply(Arrays.asList(span1, span2), (boolean)false, (boolean)false)).containsExactly((Object[])new List[]{Arrays.asList(span2), Arrays.asList(span1)});
    }

    @Test
    public void noop_whenMixedAndNeitherStrictNorAdjusting() {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        trace.set(0, ((Span)trace.get(0)).toBuilder().traceIdHigh(1L).build());
        Assertions.assertThat((List)GroupByTraceId.apply(trace, (boolean)false, (boolean)false)).containsExactly((Object[])new List[]{trace});
    }

    @Test
    public void adjusts() {
        Assertions.assertThat((List)GroupByTraceId.apply(TestObjects.TRACE, (boolean)false, (boolean)true)).containsExactly((Object[])new List[]{CorrectForClockSkew.apply((List)MergeById.apply(TestObjects.TRACE))});
    }

    @Test
    public void groupsWhenStrict() {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        trace.set(0, ((Span)trace.get(0)).toBuilder().traceIdHigh(1L).build());
        Assertions.assertThat((List)GroupByTraceId.apply(trace, (boolean)true, (boolean)false)).containsExactly((Object[])new List[]{Arrays.asList((Span)trace.get(1), (Span)trace.get(2)), Arrays.asList((Span)trace.get(0))});
    }
}

