/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.DependencyLink;
import zipkin.TestObjects;
import zipkin.internal.DependencyLinkSpan;
import zipkin.internal.DependencyLinker;

public class DependencyLinkerTest {
    @Test
    public void baseCase() {
        Assertions.assertThat((List)new DependencyLinker().link()).isEmpty();
    }

    @Test
    public void linksSpans() {
        Assertions.assertThat((List)new DependencyLinker().putTrace(TestObjects.TRACE).link()).containsExactly((Object[])new DependencyLink[]{DependencyLink.create((String)"web", (String)"app", (long)1L), DependencyLink.create((String)"app", (String)"db", (long)1L)});
    }

    @Test
    public void doesntLinkUnknownRootSpans() {
        List<DependencyLinkSpan> unknownRootSpans = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.UNKNOWN, null, null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.UNKNOWN, "server", "client"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.UNKNOWN, "client", "server"));
        for (DependencyLinkSpan span : unknownRootSpans) {
            Assertions.assertThat((List)new DependencyLinker().putTrace(Arrays.asList(span).iterator()).link()).isEmpty();
        }
    }

    @Test
    public void linksSpansDirectedByKind() {
        List<DependencyLinkSpan> validRootSpans = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "server", "client"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.CLIENT, "client", "server"));
        for (DependencyLinkSpan span : validRootSpans) {
            Assertions.assertThat((List)new DependencyLinker().putTrace(Arrays.asList(span).iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)1L)});
        }
    }

    @Test
    public void callsAgainstTheSameLinkIncreasesCallCount_span() {
        List<DependencyLinkSpan> trace = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "client", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(1L), 2L, DependencyLinkSpan.Kind.CLIENT, null, "server"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(1L), 3L, DependencyLinkSpan.Kind.CLIENT, null, "server"));
        Assertions.assertThat((List)new DependencyLinker().putTrace(trace.iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)2L)});
    }

    @Test
    public void callsAgainstTheSameLinkIncreasesCallCount_trace() {
        List<DependencyLinkSpan> trace = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "client", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(1L), 2L, DependencyLinkSpan.Kind.CLIENT, null, "server"));
        Assertions.assertThat((List)new DependencyLinker().putTrace(trace.iterator()).putTrace(trace.iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)2L)});
    }

    @Test
    public void singleHostSpansResultInASingleCallCount() {
        List<List> singleLinks = Arrays.asList(Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.CLIENT, "client", "server"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(1L), 2L, DependencyLinkSpan.Kind.SERVER, "server", null)), Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 3L), null, 3L, DependencyLinkSpan.Kind.SERVER, "client", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 3L), Long.valueOf(3L), 4L, DependencyLinkSpan.Kind.CLIENT, "client", "server")));
        for (List trace : singleLinks) {
            Assertions.assertThat((List)new DependencyLinker().putTrace(trace.iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)1L)});
        }
    }

    @Test
    public void intermediatedClientSpansMissingLocalServiceNameLinkToNearestServer() {
        List<DependencyLinkSpan> trace = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "client", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(1L), 2L, DependencyLinkSpan.Kind.UNKNOWN, null, null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(2L), 3L, DependencyLinkSpan.Kind.CLIENT, null, "server"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), Long.valueOf(2L), 4L, DependencyLinkSpan.Kind.CLIENT, null, "server"));
        Assertions.assertThat((List)new DependencyLinker().putTrace(trace.iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)2L)});
    }

    @Test
    public void linksLoopbackSpans() {
        List<DependencyLinkSpan> validRootSpans = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "service", "service"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 2L), null, 2L, DependencyLinkSpan.Kind.CLIENT, "service", "service"));
        for (DependencyLinkSpan span : validRootSpans) {
            Assertions.assertThat((List)new DependencyLinker().putTrace(Arrays.asList(span).iterator()).link()).containsOnly((Object[])new DependencyLink[]{DependencyLink.create((String)"service", (String)"service", (long)1L)});
        }
    }

    @Test
    public void cannotLinkSingleSpanWithoutBothServiceNames() {
        List<DependencyLinkSpan> incompleteRootSpans = Arrays.asList(new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, null, null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, "server", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.SERVER, null, "client"), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.CLIENT, null, null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.CLIENT, "client", null), new DependencyLinkSpan(new DependencyLinkSpan.TraceId(0L, 1L), null, 1L, DependencyLinkSpan.Kind.CLIENT, null, "server"));
        for (DependencyLinkSpan span : incompleteRootSpans) {
            Assertions.assertThat((List)new DependencyLinker().putTrace(Arrays.asList(span).iterator()).link()).isEmpty();
        }
    }

    @Test
    public void merge() {
        List<DependencyLink> links = Arrays.asList(DependencyLink.create((String)"client", (String)"server", (long)2L), DependencyLink.create((String)"client", (String)"server", (long)2L), DependencyLink.create((String)"client", (String)"client", (long)1L));
        Assertions.assertThat((List)DependencyLinker.merge(links)).containsExactly((Object[])new DependencyLink[]{DependencyLink.create((String)"client", (String)"server", (long)4L), DependencyLink.create((String)"client", (String)"client", (long)1L)});
    }
}

