/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.internal.DependencyLinkSpan;

public class DependencyLinkSpanTest {
    @Test
    public void testToString() {
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).build()).hasToString("{\"traceId\": \"0000000000000001\", \"id\": \"0000000000000001\", \"kind\": \"UNKNOWN\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).build()).hasToString("{\"traceId\": \"0000000000000001\", \"parentId\": \"0000000000000001\", \"id\": \"0000000000000002\", \"kind\": \"UNKNOWN\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).srService("processor").caService("kinesis").build()).hasToString("{\"traceId\": \"0000000000000001\", \"parentId\": \"0000000000000001\", \"id\": \"0000000000000002\", \"kind\": \"SERVER\", \"service\": \"processor\", \"peerService\": \"kinesis\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).caService("kinesis").build()).hasToString("{\"traceId\": \"0000000000000001\", \"parentId\": \"0000000000000001\", \"id\": \"0000000000000002\", \"kind\": \"UNKNOWN\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).saService("mysql").build()).hasToString("{\"traceId\": \"0000000000000001\", \"parentId\": \"0000000000000001\", \"id\": \"0000000000000002\", \"kind\": \"CLIENT\", \"peerService\": \"mysql\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).caService("shell-script").saService("mysql").build()).hasToString("{\"traceId\": \"0000000000000001\", \"parentId\": \"0000000000000001\", \"id\": \"0000000000000002\", \"kind\": \"CLIENT\", \"service\": \"shell-script\", \"peerService\": \"mysql\"}");
        Assertions.assertThat((Object)DependencyLinkSpan.builder((long)3L, (long)1L, null, (long)1L).build()).hasToString("{\"traceId\": \"00000000000000030000000000000001\", \"id\": \"0000000000000001\", \"kind\": \"UNKNOWN\"}");
    }

    @Test
    public void parentAndChildApply() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).build();
        Assertions.assertThat((Long)span.parentId).isNull();
        Assertions.assertThat((long)span.id).isEqualTo(1L);
        span = DependencyLinkSpan.builder((long)0L, (long)1L, (Long)1L, (long)2L).build();
        Assertions.assertThat((Long)span.parentId).isEqualTo(1L);
        Assertions.assertThat((long)span.id).isEqualTo(2L);
    }

    @Test
    public void whenNoServiceLabelsExist_kindIsUnknown() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.UNKNOWN);
        Assertions.assertThat((String)span.peerService).isNull();
        Assertions.assertThat((String)span.service).isNull();
    }

    @Test
    public void whenOnlyAddressLabelsExist_kindIsClient() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).caService("service1").saService("service2").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.CLIENT);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service1");
        Assertions.assertThat((String)span.peerService).isEqualTo((Object)"service2");
    }

    @Test
    public void whenServerLabelsAreMissing_kindIsUnknownAndLabelsAreCleared() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).caService("service1").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.UNKNOWN);
        Assertions.assertThat((String)span.service).isNull();
        Assertions.assertThat((String)span.peerService).isNull();
    }

    @Test
    public void whenSrServiceExists_kindIsServer() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).srService("service").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.SERVER);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service");
        Assertions.assertThat((String)span.peerService).isNull();
    }

    @Test
    public void whenSrAndCaServiceExists_caIsThePeer() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).caService("service1").srService("service2").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.SERVER);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service2");
        Assertions.assertThat((String)span.peerService).isEqualTo((Object)"service1");
    }

    @Test
    public void whenSrAndCsServiceExists_caIsThePeer() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).csService("service1").srService("service2").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.SERVER);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service2");
        Assertions.assertThat((String)span.peerService).isEqualTo((Object)"service1");
    }

    @Test
    public void whenCrAndCaServiceExists_caIsThePeer() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).csService("foo").caService("service1").srService("service2").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.SERVER);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service2");
        Assertions.assertThat((String)span.peerService).isEqualTo((Object)"service1");
    }

    @Test
    public void specialCasesFinagleLocalSocketLabeling() {
        DependencyLinkSpan span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).caService("service").saService("service").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.CLIENT);
        Assertions.assertThat((String)span.service).isNull();
        Assertions.assertThat((String)span.peerService).isEqualTo((Object)"service");
        span = DependencyLinkSpan.builder((long)0L, (long)1L, null, (long)1L).srService("service").caService("service").saService("service").build();
        Assertions.assertThat((Comparable)span.kind).isEqualTo((Object)DependencyLinkSpan.Kind.SERVER);
        Assertions.assertThat((String)span.service).isEqualTo((Object)"service");
        Assertions.assertThat((String)span.peerService).isNull();
    }
}

