/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import org.junit.Assert;
import org.junit.Test;
import sun.net.util.IPAddressUtil;
import zipkin.Endpoint;
import zipkin.internal.CorrectForClockSkew;

public class CorrectForClockSkewTest {
    Endpoint ipv6 = Endpoint.builder().serviceName("web").ipv6(IPAddressUtil.textToNumericFormatV6("2001:db8::c001")).build();
    Endpoint ipv4 = Endpoint.builder().serviceName("web").ipv4(2081249794).build();
    Endpoint both;

    public CorrectForClockSkewTest() {
        this.both = this.ipv4.toBuilder().ipv6(this.ipv6.ipv6).build();
    }

    @Test
    public void ipsMatch_falseWhenNoIp() {
        Endpoint noIp = Endpoint.builder().serviceName("foo").build();
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)noIp, (Endpoint)this.ipv4));
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)noIp, (Endpoint)this.ipv6));
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv4, (Endpoint)noIp));
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv6, (Endpoint)noIp));
    }

    @Test
    public void ipsMatch_falseWhenIpv4Different() {
        Endpoint different = this.ipv4.toBuilder().ipv4(2081249795).build();
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)different, (Endpoint)this.ipv4));
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv4, (Endpoint)different));
    }

    @Test
    public void ipsMatch_falseWhenIpv6Different() {
        Endpoint different = this.ipv6.toBuilder().ipv6(IPAddressUtil.textToNumericFormatV6("2001:db8::c002")).build();
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)different, (Endpoint)this.ipv6));
        Assert.assertFalse((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv6, (Endpoint)different));
    }

    @Test
    public void ipsMatch_whenIpv6Match() {
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv6, (Endpoint)this.ipv6));
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.both, (Endpoint)this.ipv6));
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv6, (Endpoint)this.both));
    }

    @Test
    public void ipsMatch_whenIpv4Match() {
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv4, (Endpoint)this.ipv4));
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.both, (Endpoint)this.ipv4));
        Assert.assertTrue((boolean)CorrectForClockSkew.ipsMatch((Endpoint)this.ipv4, (Endpoint)this.both));
    }
}

