/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import zipkin.internal.CallbackCaptor;

public class CallbackCaptorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void getIsUninterruptable() {
        AtomicBoolean returned = new AtomicBoolean();
        CallbackCaptor captor = new CallbackCaptor();
        Thread thread = new Thread(() -> {
            captor.get();
            returned.set(true);
        });
        thread.start();
        thread.interrupt();
        Assertions.assertThat((boolean)thread.isInterrupted()).isTrue();
        Assertions.assertThat((boolean)returned.get()).isFalse();
    }

    @Test
    public void onSuccessReturns() {
        CallbackCaptor captor = new CallbackCaptor();
        captor.onSuccess((Object)"foo");
        Assertions.assertThat((String)((String)captor.get())).isEqualTo((Object)"foo");
    }

    @Test
    public void onError_propagatesRuntimeException() {
        CallbackCaptor captor = new CallbackCaptor();
        captor.onError((Throwable)new IllegalStateException());
        this.thrown.expect(IllegalStateException.class);
        captor.get();
    }

    @Test
    public void onError_propagatesError() {
        CallbackCaptor captor = new CallbackCaptor();
        captor.onError((Throwable)new LinkageError());
        this.thrown.expect(LinkageError.class);
        captor.get();
    }

    @Test
    public void onError_wrapsCheckedExceptions() {
        CallbackCaptor captor = new CallbackCaptor();
        captor.onError((Throwable)new IOException());
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(Is.isA(IOException.class));
        captor.get();
    }
}

