/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import sun.net.util.IPAddressUtil;
import zipkin.internal.Buffer;
import zipkin.internal.Util;

public class BufferTest {
    @Test
    public void utf8SizeInBytes() {
        for (int codepoint = 0; codepoint <= 0x10FFFF; ++codepoint) {
            if (codepoint == 55296) {
                codepoint = 57344;
            }
            if (!Character.isDefined(codepoint)) continue;
            String test = new String(Character.toChars(codepoint));
            int expected = test.getBytes(Util.UTF_8).length;
            int actual = Buffer.utf8SizeInBytes((String)test);
            if (actual != expected) {
                throw new AssertionError((Object)(actual + " length != " + expected + " for " + codepoint));
            }
        }
    }

    @Test
    public void emoji() {
        byte[] emojiBytes = new byte[]{-16, -97, -104, -127};
        String emoji = new String(emojiBytes, Util.UTF_8);
        Assertions.assertThat((int)Buffer.utf8SizeInBytes((String)emoji)).isEqualTo(emojiBytes.length);
        Assertions.assertThat((byte[])new Buffer(emojiBytes.length).writeUtf8(emoji).toByteArray()).isEqualTo((Object)emojiBytes);
    }

    @Test
    public void ipv6() {
        Assertions.assertThat((String)BufferTest.writeIpV6("1:2:3:4:5:6:7:8")).isEqualTo((Object)"1:2:3:4:5:6:7:8");
        Assertions.assertThat((String)BufferTest.writeIpV6("2001:0:0:4:0000:0:0:8")).isEqualTo((Object)"2001:0:0:4::8");
        Assertions.assertThat((String)BufferTest.writeIpV6("2001:0:0:4:5:6:7:8")).isEqualTo((Object)"2001::4:5:6:7:8");
        Assertions.assertThat((String)BufferTest.writeIpV6("2001:0:3:4:5:6:7:8")).isEqualTo((Object)"2001::3:4:5:6:7:8");
        Assertions.assertThat((String)BufferTest.writeIpV6("0:0:3:0:0:0:0:ffff")).isEqualTo((Object)"0:0:3::ffff");
        Assertions.assertThat((String)BufferTest.writeIpV6("0:0:0:4:0:0:0:ffff")).isEqualTo((Object)"::4:0:0:0:ffff");
        Assertions.assertThat((String)BufferTest.writeIpV6("0:0:0:0:5:0:0:ffff")).isEqualTo((Object)"::5:0:0:ffff");
        Assertions.assertThat((String)BufferTest.writeIpV6("1:0:0:4:0:0:7:8")).isEqualTo((Object)"1::4:0:0:7:8");
        Assertions.assertThat((String)BufferTest.writeIpV6("0:0:0:0:0:0:0:0")).isEqualTo((Object)"::");
        Assertions.assertThat((String)BufferTest.writeIpV6("0:0:0:0:0:0:0:1")).isEqualTo((Object)"::1");
        Assertions.assertThat((String)BufferTest.writeIpV6("2001:0658:022a:cafe::")).isEqualTo((Object)"2001:658:22a:cafe::");
        Assertions.assertThat((String)BufferTest.writeIpV6("::1.2.3.4")).isEqualTo((Object)"::102:304");
    }

    static String writeIpV6(String address) {
        byte[] ipv6 = IPAddressUtil.textToNumericFormatV6(address);
        byte[] buffered = new Buffer(Buffer.ipv6SizeInBytes((byte[])ipv6)).writeIpV6(ipv6).toByteArray();
        return new String(buffered, Util.UTF_8);
    }

    @Test
    public void asciiSizeInBytes_long() throws IOException {
        Assertions.assertThat((int)Buffer.asciiSizeInBytes((long)0L)).isEqualTo(1);
        Assertions.assertThat((int)Buffer.asciiSizeInBytes((long)-1005656679588439279L)).isEqualTo(20);
        Assertions.assertThat((int)Buffer.asciiSizeInBytes((long)Long.MIN_VALUE)).isEqualTo(20);
        Assertions.assertThat((int)Buffer.asciiSizeInBytes((long)123456789L)).isEqualTo(9);
    }

    @Test
    public void writeAscii_long() throws IOException {
        Assertions.assertThat((String)BufferTest.writeAscii(-1005656679588439279L)).isEqualTo((Object)"-1005656679588439279");
        Assertions.assertThat((String)BufferTest.writeAscii(0L)).isEqualTo((Object)"0");
        Assertions.assertThat((String)BufferTest.writeAscii(Long.MIN_VALUE)).isEqualTo((Object)"-9223372036854775808");
        Assertions.assertThat((String)BufferTest.writeAscii(123456789L)).isEqualTo((Object)"123456789");
    }

    static String writeAscii(long v) {
        byte[] buffered = new Buffer(Buffer.asciiSizeInBytes((long)v)).writeAscii(v).toByteArray();
        return new String(buffered, Util.UTF_8);
    }

    @Test
    public void jsonEscapedSizeInBytes_string() throws IOException {
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((String)new String(new char[]{'\u0000', 'a', '\u0001'}))).isEqualTo(13);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((String)new String(new char[]{'\"', '\\', '\t', '\b'}))).isEqualTo(8);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((String)new String(new char[]{'\n', '\r', '\f'}))).isEqualTo(6);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((String)"\u2028 and \u2029")).isEqualTo(17);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((String)"\"foo")).isEqualTo(5);
    }

    @Test
    public void jsonEscapedSizeInBytes_bytes() throws IOException {
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((byte[])new byte[]{0, 97, 1})).isEqualTo(13);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((byte[])new byte[]{34, 92, 9, 8})).isEqualTo(8);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((byte[])new byte[]{10, 13, 12})).isEqualTo(6);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((byte[])"\u2028 and \u2029".getBytes(Util.UTF_8))).isEqualTo(17);
        Assertions.assertThat((int)Buffer.jsonEscapedSizeInBytes((byte[])"\"foo".getBytes(Util.UTF_8))).isEqualTo(5);
    }

    @Test
    public void writeJsonEscaped_string() throws IOException {
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new String(new char[]{'\u0000', 'a', '\u0001'}))).isEqualTo((Object)"\\u0000a\\u0001");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new String(new char[]{'\"', '\\', '\t', '\b'}))).isEqualTo((Object)"\\\"\\\\\\t\\b");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new String(new char[]{'\n', '\r', '\f'}))).isEqualTo((Object)"\\n\\r\\f");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped("\u2028 and \u2029")).isEqualTo((Object)"\\u2028 and \\u2029");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped("\"foo")).isEqualTo((Object)"\\\"foo");
    }

    @Test
    public void writeJsonEscaped_bytes() throws IOException {
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new byte[]{0, 97, 1})).isEqualTo((Object)"\\u0000a\\u0001");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new byte[]{34, 92, 9, 8})).isEqualTo((Object)"\\\"\\\\\\t\\b");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped(new byte[]{10, 13, 12})).isEqualTo((Object)"\\n\\r\\f");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped("\u2028 and \u2029".getBytes(Util.UTF_8))).isEqualTo((Object)"\\u2028 and \\u2029");
        Assertions.assertThat((String)BufferTest.writeJsonEscaped("\"foo".getBytes(Util.UTF_8))).isEqualTo((Object)"\\\"foo");
    }

    static String writeJsonEscaped(String v) {
        byte[] buffered = new Buffer(Buffer.jsonEscapedSizeInBytes((String)v)).writeJsonEscaped(v).toByteArray();
        return new String(buffered, Util.UTF_8);
    }

    static String writeJsonEscaped(byte[] v) {
        byte[] buffered = new Buffer(Buffer.jsonEscapedSizeInBytes((byte[])v)).writeJsonEscaped(v).toByteArray();
        return new String(buffered, Util.UTF_8);
    }
}

