/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Annotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;

public class ApplyTimestampAndDurationTest {
    Endpoint frontend = Endpoint.builder().serviceName("frontend").ipv4(-1072955391).port(8080).build();
    Annotation cs = Annotation.create((long)50000L, (String)"cs", (Endpoint)this.frontend);
    Endpoint backend = Endpoint.builder().serviceName("backend").ipv4(-1072955390).port(8080).build();
    Annotation sr = Annotation.create((long)95000L, (String)"sr", (Endpoint)this.backend);
    Span.Builder span = Span.builder().traceId(1L).name("method1").id(666L);

    @Test
    public void bestTimestamp_isSpanTimestamp() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.timestamp(Long.valueOf(1L)).build())).isEqualTo(1L);
    }

    @Test
    public void bestTimestamp_isNotARandomAnnotation() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.addAnnotation(Annotation.create((long)1L, (String)"foo", (Endpoint)this.frontend)).build())).isNull();
    }

    @Test
    public void bestTimestamp_isARootServerSpan() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.addAnnotation(this.sr).build())).isEqualTo(this.sr.timestamp);
    }

    @Test
    public void bestTimestamp_isClientSideOFARootSpan() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.addAnnotation(this.cs).addAnnotation(this.sr).build())).isEqualTo(this.cs.timestamp);
    }

    @Test
    public void bestTimestamp_isNotAChildServerSpan() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.parentId(Long.valueOf(2L)).addAnnotation(this.sr).build())).isNull();
    }

    @Test
    public void bestTimestamp_isAChildClientSpan() {
        Assertions.assertThat((Long)ApplyTimestampAndDuration.guessTimestamp((Span)this.span.parentId(Long.valueOf(2L)).addAnnotation(this.cs).build())).isEqualTo(this.cs.timestamp);
    }
}

