/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.collector.Collector;
import zipkin.collector.CollectorSampler;
import zipkin.storage.Callback;
import zipkin.storage.InMemoryStorage;
import zipkin.storage.StorageComponent;

public class CollectorTest {
    List<String> messages = new ArrayList<String>();
    Collector collector = new Collector.Builder(new Logger("", null){

        @Override
        public void log(Level level, String msg, Throwable thrown) {
            Assertions.assertThat((Object)level).isEqualTo((Object)Level.WARNING);
            CollectorTest.this.messages.add(msg);
        }
    }).storage((StorageComponent)new InMemoryStorage()).build();
    Span span1 = Span.builder().traceId(1L).id(1L).name("foo").build();
    Span span2 = Span.builder().traceId(1L).parentId(Long.valueOf(1L)).id(2L).name("bar").build();

    @Test
    public void acceptSpansCallback_toStringIncludesSpanIds() {
        Assertions.assertThat((Object)this.collector.acceptSpansCallback(Arrays.asList(this.span1, this.span2))).hasToString("AcceptSpans([0000000000000001.0000000000000001<:0000000000000001, 0000000000000001.0000000000000002<:0000000000000001])");
    }

    @Test
    public void acceptSpansCallback_onErrorWithNullMessage() {
        Callback callback = this.collector.acceptSpansCallback(Arrays.asList(this.span1));
        callback.onError((Throwable)new RuntimeException());
        Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{"Cannot store spans [0000000000000001.0000000000000001<:0000000000000001] due to RuntimeException()"});
    }

    @Test
    public void acceptSpansCallback_onErrorWithMessage() {
        Callback callback = this.collector.acceptSpansCallback(Arrays.asList(this.span1));
        callback.onError((Throwable)new IllegalArgumentException("no beer"));
        Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{"Cannot store spans [0000000000000001.0000000000000001<:0000000000000001] due to IllegalArgumentException(no beer)"});
    }

    @Test
    public void errorAcceptingSpans_onErrorWithNullMessage() {
        String message = this.collector.errorStoringSpans(Arrays.asList(this.span1), (Throwable)new RuntimeException()).getMessage();
        ((AbstractListAssert)Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{message})).containsExactly((Object[])new String[]{"Cannot store spans [0000000000000001.0000000000000001<:0000000000000001] due to RuntimeException()"});
    }

    @Test
    public void errorAcceptingSpans_onErrorWithMessage() {
        String message = this.collector.errorStoringSpans(Arrays.asList(this.span1), (Throwable)new IllegalArgumentException("no beer")).getMessage();
        ((AbstractListAssert)Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{message})).containsExactly((Object[])new String[]{"Cannot store spans [0000000000000001.0000000000000001<:0000000000000001] due to IllegalArgumentException(no beer)"});
    }

    @Test
    public void errorDecoding_onErrorWithNullMessage() {
        String message = this.collector.errorReading((Throwable)new RuntimeException()).getMessage();
        ((AbstractListAssert)Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{message})).containsExactly((Object[])new String[]{"Cannot decode spans due to RuntimeException()"});
    }

    @Test
    public void errorDecoding_onErrorWithMessage() {
        String message = this.collector.errorReading((Throwable)new IllegalArgumentException("no beer")).getMessage();
        ((AbstractListAssert)Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{message})).containsExactly((Object[])new String[]{"Cannot decode spans due to IllegalArgumentException(no beer)"});
    }

    @Test
    public void errorDecoding_doesntWrapMalformedException() {
        String message = this.collector.errorReading((Throwable)new IllegalArgumentException("Malformed reading spans")).getMessage();
        ((AbstractListAssert)Assertions.assertThat(this.messages).containsExactly((Object[])new String[]{message})).containsExactly((Object[])new String[]{"Malformed reading spans"});
    }

    @Test
    public void debugFlagWins() {
        this.collector.accept(Arrays.asList(TestObjects.span(Long.MIN_VALUE).toBuilder().debug(Boolean.valueOf(true)).build()), Callback.NOOP);
        Assertions.assertThat((List)this.collector.storage.spanStore().getServiceNames()).containsExactly((Object[])new String[]{"service"});
    }

    @Test
    public void unsampledSpansArentStored() {
        this.collector = Collector.builder(Collector.class).sampler(CollectorSampler.create((float)0.0f)).storage((StorageComponent)new InMemoryStorage()).build();
        this.collector.accept(Arrays.asList(TestObjects.span(Long.MIN_VALUE)), Callback.NOOP);
        Assertions.assertThat((List)this.collector.storage.spanStore().getServiceNames()).isEmpty();
    }
}

