/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import zipkin.TestObjects;
import zipkin.collector.CollectorSampler;

public class CollectorSamplerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void mostNegativeNumberDefence() {
        CollectorSampler sampler = CollectorSampler.create((float)0.1f);
        Assertions.assertThat((boolean)sampler.isSampled(TestObjects.span(Long.MIN_VALUE))).isEqualTo(sampler.isSampled(TestObjects.span(Long.MAX_VALUE)));
    }

    @Test
    public void debugWins() {
        CollectorSampler sampler = CollectorSampler.create((float)0.0f);
        Assertions.assertThat((boolean)sampler.isSampled(TestObjects.span(Long.MIN_VALUE).toBuilder().debug(Boolean.valueOf(true)).build())).isTrue();
    }

    @Test
    public void retain10Percent() {
        float sampleRate = 0.1f;
        CollectorSampler sampler = CollectorSampler.create((float)sampleRate);
        long passCount = ((Stream)Stream.of(TestObjects.LOTS_OF_SPANS).parallel()).filter(arg_0 -> ((CollectorSampler)sampler).isSampled(arg_0)).count();
        Assertions.assertThat((long)passCount).isCloseTo((long)((float)TestObjects.LOTS_OF_SPANS.length * sampleRate), Percentage.withPercentage((double)3.0));
    }

    @Test
    public void idempotent() {
        CollectorSampler sampler1 = CollectorSampler.create((float)0.1f);
        CollectorSampler sampler2 = CollectorSampler.create((float)0.1f);
        Assertions.assertThat((Object[])((Stream)Stream.of(TestObjects.LOTS_OF_SPANS).parallel()).filter(arg_0 -> ((CollectorSampler)sampler1).isSampled(arg_0)).toArray()).containsExactly(((Stream)Stream.of(TestObjects.LOTS_OF_SPANS).parallel()).filter(arg_0 -> ((CollectorSampler)sampler2).isSampled(arg_0)).toArray());
    }

    @Test
    public void zeroMeansDropAllTraces() {
        CollectorSampler sampler = CollectorSampler.create((float)0.0f);
        Assertions.assertThat(((Stream)Stream.of(TestObjects.LOTS_OF_SPANS).parallel()).filter(arg_0 -> ((CollectorSampler)sampler).isSampled(arg_0)).findAny()).isEmpty();
    }

    @Test
    public void oneMeansKeepAllTraces() {
        CollectorSampler sampler = CollectorSampler.create((float)1.0f);
        Assertions.assertThat((long)((Stream)Stream.of(TestObjects.LOTS_OF_SPANS).parallel()).filter(arg_0 -> ((CollectorSampler)sampler).isSampled(arg_0)).count()).isEqualTo((long)TestObjects.LOTS_OF_SPANS.length);
    }

    @Test
    public void rateCantBeNegative() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("rate should be between 0 and 1: was -1.0");
        CollectorSampler.create((float)-1.0f);
    }

    @Test
    public void rateCantBeOverOne() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("rate should be between 0 and 1: was 1.1");
        CollectorSampler.create((float)1.1f);
    }
}

