/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import sun.net.util.IPAddressUtil;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Dependencies;
import zipkin.internal.Util;

public final class TestObjects {
    public static final long DAY = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
    public static final long TODAY = Util.midnightUTC((long)System.currentTimeMillis());
    public static final Endpoint WEB_ENDPOINT = Endpoint.builder().serviceName("web").ipv4(2081249795).ipv6(IPAddressUtil.textToNumericFormatV6("2001:db8::c001")).port(80).build();
    public static final Endpoint APP_ENDPOINT = Endpoint.builder().serviceName("app").ipv4(-1408172030).port(8080).build();
    public static final Endpoint DB_ENDPOINT = Endpoint.builder().serviceName("db").ipv4(-1408172030).port(3306).build();
    public static final Endpoint NO_IP_ENDPOINT = Endpoint.builder().serviceName("no_ip").build();
    static final long WEB_SPAN_ID = -692101025335252320L;
    static final long APP_SPAN_ID = -7842865617155193778L;
    static final long DB_SPAN_ID = 8207293009014896295L;
    public static final List<Span> TRACE = Arrays.asList(Span.builder().traceId(-692101025335252320L).id(-692101025335252320L).name("get").addAnnotation(Annotation.create((long)(TODAY * 1000L), (String)"sr", (Endpoint)WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 350L) * 1000L), (String)"ss", (Endpoint)WEB_ENDPOINT)).build(), Span.builder().traceId(-692101025335252320L).parentId(Long.valueOf(-692101025335252320L)).id(-7842865617155193778L).name("get").addAnnotation(Annotation.create((long)((TODAY + 50L) * 1000L), (String)"cs", (Endpoint)WEB_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 100L) * 1000L), (String)"sr", (Endpoint)APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 250L) * 1000L), (String)"ss", (Endpoint)APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 300L) * 1000L), (String)"cr", (Endpoint)WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)WEB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)APP_ENDPOINT)).build(), Span.builder().traceId(-692101025335252320L).parentId(Long.valueOf(-7842865617155193778L)).id(8207293009014896295L).name("query").addAnnotation(Annotation.create((long)((TODAY + 150L) * 1000L), (String)"cs", (Endpoint)APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 200L) * 1000L), (String)"cr", (Endpoint)APP_ENDPOINT)).addAnnotation(Annotation.create((long)((TODAY + 190L) * 1000L), (String)"\u2ee9", (Endpoint)NO_IP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (Endpoint)APP_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)DB_ENDPOINT)).addBinaryAnnotation(BinaryAnnotation.create((String)"error", (String)"\ud83d\udca9", (Endpoint)NO_IP_ENDPOINT)).build()).stream().map(ApplyTimestampAndDuration::apply).collect(Collectors.toList());
    public static final List<DependencyLink> LINKS = Arrays.asList(DependencyLink.builder().parent("web").child("app").callCount(1L).build(), DependencyLink.builder().parent("app").child("db").callCount(1L).build());
    public static final Dependencies DEPENDENCIES = Dependencies.create((long)TODAY, (long)(TODAY + 1000L), LINKS);
    static final Span.Builder spanBuilder = TestObjects.spanBuilder();
    public static final Span[] LOTS_OF_SPANS = (Span[])new Random().longs(100000L).mapToObj(t -> TestObjects.span(t)).toArray(Span[]::new);

    static Span.Builder spanBuilder() {
        Endpoint e = Endpoint.builder().serviceName("service").ipv4(2130706433).port(8080).build();
        Annotation sr = Annotation.create((long)(System.currentTimeMillis() * 1000L), (String)"sr", (Endpoint)e);
        Annotation ss = Annotation.create((long)(sr.timestamp + 1000L), (String)"ss", (Endpoint)e);
        BinaryAnnotation ba = BinaryAnnotation.create((String)"http.method", (String)"GET", (Endpoint)e);
        return Span.builder().name("get").addAnnotation(sr).addAnnotation(ss).addBinaryAnnotation(ba);
    }

    public static Span span(long traceId) {
        return spanBuilder.traceId(traceId).id(traceId).build();
    }
}

