/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import okio.Buffer;
import okio.ByteString;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.TestObjects;
import zipkin.internal.Util;

public class SpanTest {
    @Test
    public void traceIdHigh() {
        Span with128BitId = Span.builder().traceId(Util.lowerHexToUnsignedLong((String)"48485a3953bb6124")).traceIdHigh(Util.lowerHexToUnsignedLong((String)"463ac35c9f6413ad")).id(1L).name("foo").build();
        Assertions.assertThat((String)with128BitId.idString()).isEqualTo((Object)"463ac35c9f6413ad48485a3953bb6124.0000000000000001<:0000000000000001");
    }

    @Test
    public void idString_withParent() {
        Span withParent = Span.builder().name("foo").traceId(1L).id(3L).parentId(Long.valueOf(2L)).build();
        Assertions.assertThat((String)withParent.idString()).isEqualTo((Object)"0000000000000001.0000000000000003<:0000000000000002");
    }

    @Test
    public void idString_noParent() {
        Span noParent = Span.builder().name("foo").traceId(1L).id(1L).build();
        Assertions.assertThat((String)noParent.idString()).isEqualTo((Object)"0000000000000001.0000000000000001<:0000000000000001");
    }

    @Test
    public void spanNamesLowercase() {
        Assertions.assertThat((String)Span.builder().traceId((long)1L).id((long)1L).name((String)"GET").build().name).isEqualTo((Object)"get");
    }

    @Test
    public void mergeWhenBinaryAnnotationsSentSeparately() {
        Span part1 = Span.builder().traceId(1L).name("").id(1L).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT)).build();
        Span part2 = Span.builder().traceId(1L).name("get").id(1L).timestamp(Long.valueOf(1444438900939000L)).duration(Long.valueOf(376000L)).addAnnotation(Annotation.create((long)1444438900939000L, (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).addAnnotation(Annotation.create((long)1444438901315000L, (String)"ss", (Endpoint)TestObjects.APP_ENDPOINT)).build();
        Span expected = part2.toBuilder().addBinaryAnnotation((BinaryAnnotation)part1.binaryAnnotations.get(0)).build();
        Assertions.assertThat((Comparable)part1.toBuilder().merge(part2).build()).isEqualTo((Object)expected);
        Assertions.assertThat((Comparable)part2.toBuilder().merge(part1).build()).isEqualTo((Object)expected);
    }

    @Test
    public void mergeOverridesDummySpanNames() {
        for (String nonName : Arrays.asList("", "unknown")) {
            Span unknown = Span.builder().traceId(1L).id(2L).name(nonName).build();
            Span get = unknown.toBuilder().name("get").build();
            Assertions.assertThat((String)unknown.toBuilder().merge((Span)get).build().name).isEqualTo((Object)"get");
            Assertions.assertThat((String)get.toBuilder().merge((Span)unknown).build().name).isEqualTo((Object)"get");
        }
    }

    @Test
    public void serviceNames_includeBinaryAnnotations() {
        Span span = Span.builder().traceId(1L).name("GET").id(1L).addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)TestObjects.APP_ENDPOINT)).build();
        Assertions.assertThat((Iterable)span.serviceNames()).containsOnly((Object[])new String[]{TestObjects.APP_ENDPOINT.serviceName});
    }

    @Test
    public void serviceNames_ignoresAnnotationsWithEmptyServiceNames() {
        Span span = Span.builder().traceId(12345L).id(666L).name("methodcall").addAnnotation(Annotation.create((long)1L, (String)"test", (Endpoint)Endpoint.create((String)"", (int)2130706433))).addAnnotation(Annotation.create((long)2L, (String)"sr", (Endpoint)TestObjects.APP_ENDPOINT)).build();
        Assertions.assertThat((Iterable)span.serviceNames()).containsOnly((Object[])new String[]{TestObjects.APP_ENDPOINT.serviceName});
    }

    @Test
    public void sortsBinaryAnnotationsByKey() {
        BinaryAnnotation foo = BinaryAnnotation.create((String)"foo", (String)"bar", (Endpoint)TestObjects.APP_ENDPOINT);
        BinaryAnnotation baz = BinaryAnnotation.create((String)"baz", (String)"qux", (Endpoint)TestObjects.APP_ENDPOINT);
        Span span = Span.builder().traceId(12345L).id(666L).name("methodcall").addBinaryAnnotation(foo).addBinaryAnnotation(baz).build();
        Assertions.assertThat((List)span.binaryAnnotations).containsExactly((Object[])new BinaryAnnotation[]{baz, foo});
    }

    @Test
    public void coercesTimestampZeroToNull() {
        Span span = Span.builder().traceId(1L).name("GET").id(1L).timestamp(Long.valueOf(0L)).build();
        Assertions.assertThat((Long)span.timestamp).isNull();
    }

    @Test
    public void coercesDurationZeroToNull() {
        Span span = Span.builder().traceId(1L).name("GET").id(1L).duration(Long.valueOf(0L)).build();
        Assertions.assertThat((Long)span.duration).isNull();
    }

    @Test
    public void serialization() throws Exception {
        Span span = TestObjects.TRACE.get(0);
        Buffer buffer = new Buffer();
        new ObjectOutputStream(buffer.outputStream()).writeObject(span);
        Assertions.assertThat((Object)new ObjectInputStream(buffer.inputStream()).readObject()).isEqualTo((Object)span);
    }

    @Test
    public void serializationUsesThrift() throws Exception {
        Span span = TestObjects.TRACE.get(0);
        Buffer buffer = new Buffer();
        new ObjectOutputStream(buffer.outputStream()).writeObject(span);
        byte[] thrift = Codec.THRIFT.writeSpan(span);
        Assertions.assertThat((long)buffer.indexOf(ByteString.of((byte[])thrift))).isPositive();
    }
}

