/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import sun.net.util.IPAddressUtil;
import zipkin.Endpoint;

public class EndpointTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void messageWhenMissingServiceName() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("serviceName");
        Endpoint.builder().ipv4(2130706433).build();
    }

    @Test
    public void missingIpv4CoercesTo0() {
        Assertions.assertThat((int)Endpoint.builder().serviceName((String)"foo").build().ipv4).isEqualTo(0);
    }

    @Test
    public void builderWithPort_0CoercesToNull() {
        Assertions.assertThat((Short)Endpoint.builder().serviceName((String)"foo").port((int)0).build().port).isNull();
    }

    @Test
    public void builderWithPort_highest() {
        short port = Endpoint.builder().serviceName((String)"foo").port((int)65535).build().port;
        Assertions.assertThat((short)port).isEqualTo((short)-1);
        Assertions.assertThat((int)(port & 0xFFFF)).isEqualTo(65535);
    }

    @Test
    public void builderWithPort_negativeIsInvalid() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("invalid port -1");
        Assertions.assertThat((Short)Endpoint.builder().serviceName((String)"foo").port((int)-1).build().port);
    }

    @Test
    public void builderWithPort_tooHighIsInvalid() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("invalid port 65536");
        Assertions.assertThat((Short)Endpoint.builder().serviceName((String)"foo").port((int)65536).build().port);
    }

    @Test
    public void lowercasesServiceName() {
        Assertions.assertThat((String)Endpoint.builder().serviceName((String)"fFf").ipv4((int)2130706433).build().serviceName).isEqualTo((Object)"fff");
    }

    @Test
    public void testToStringIsJson_minimal() {
        Assertions.assertThat((Object)Endpoint.builder().serviceName("foo").build()).hasToString("{\"serviceName\":\"foo\"}");
    }

    @Test
    public void testToStringIsJson_ipv4() {
        Assertions.assertThat((Object)Endpoint.builder().serviceName("foo").ipv4(2130706433).build()).hasToString("{\"serviceName\":\"foo\",\"ipv4\":\"127.0.0.1\"}");
    }

    @Test
    public void testToStringIsJson_ipv4Port() {
        Assertions.assertThat((Object)Endpoint.builder().serviceName("foo").ipv4(2130706433).port(80).build()).hasToString("{\"serviceName\":\"foo\",\"ipv4\":\"127.0.0.1\",\"port\":80}");
    }

    @Test
    public void testToStringIsJson_ipv6() {
        Assertions.assertThat((Object)Endpoint.builder().serviceName("foo").ipv6(IPAddressUtil.textToNumericFormatV6("2001:db8::c001")).build()).hasToString("{\"serviceName\":\"foo\",\"ipv6\":\"2001:db8::c001\"}");
    }
}

