/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import okio.Buffer;
import okio.ByteString;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.TestObjects;

public class DependencyLinkTest {
    @Test
    public void serialization() throws Exception {
        DependencyLink link = TestObjects.LINKS.get(0);
        Buffer buffer = new Buffer();
        new ObjectOutputStream(buffer.outputStream()).writeObject(link);
        Assertions.assertThat((Object)new ObjectInputStream(buffer.inputStream()).readObject()).isEqualTo((Object)link);
    }

    @Test
    public void serializationUsesThrift() throws Exception {
        DependencyLink link = TestObjects.LINKS.get(0);
        Buffer buffer = new Buffer();
        new ObjectOutputStream(buffer.outputStream()).writeObject(link);
        byte[] thrift = Codec.THRIFT.writeDependencyLink(link);
        Assertions.assertThat((long)buffer.indexOf(ByteString.of((byte[])thrift))).isPositive();
    }
}

