/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.TestObjects;

public abstract class CodecTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected abstract Codec codec();

    @Test
    public void spanRoundTrip() throws IOException {
        for (Span span : TestObjects.TRACE) {
            byte[] bytes = this.codec().writeSpan(span);
            Assertions.assertThat((Comparable)this.codec().readSpan(bytes)).isEqualTo((Object)span);
        }
    }

    @Test
    public void sizeInBytes() throws IOException {
        for (Span span : TestObjects.TRACE) {
            Assertions.assertThat((int)this.codec().sizeInBytes(span)).isEqualTo(this.codec().writeSpan(span).length);
        }
    }

    @Test
    public void spanRoundTrip_128bitTraceId() throws IOException {
        for (Span span : TestObjects.TRACE) {
            span = span.toBuilder().traceIdHigh(12345L).build();
            byte[] bytes = this.codec().writeSpan(span);
            Assertions.assertThat((Comparable)this.codec().readSpan(bytes)).isEqualTo((Object)span);
        }
    }

    @Test
    public void sizeInBytes_128bitTraceId() throws IOException {
        for (Span span : TestObjects.TRACE) {
            span = span.toBuilder().traceIdHigh(12345L).build();
            Assertions.assertThat((int)this.codec().sizeInBytes(span)).isEqualTo(this.codec().writeSpan(span).length);
        }
    }

    @Test
    public void binaryAnnotation_long() throws IOException {
        Span span = TestObjects.LOTS_OF_SPANS[0].toBuilder().binaryAnnotations(Arrays.asList(BinaryAnnotation.builder().key("Long.zero").type(BinaryAnnotation.Type.I64).value(ByteBuffer.allocate(8).putLong(0, 0L).array()).build(), BinaryAnnotation.builder().key("Long.negative").type(BinaryAnnotation.Type.I64).value(ByteBuffer.allocate(8).putLong(0, -1005656679588439279L).array()).build(), BinaryAnnotation.builder().key("Long.MIN_VALUE").type(BinaryAnnotation.Type.I64).value(ByteBuffer.allocate(8).putLong(0, Long.MIN_VALUE).array()).build(), BinaryAnnotation.builder().key("Long.MAX_VALUE").type(BinaryAnnotation.Type.I64).value(ByteBuffer.allocate(8).putLong(0, Long.MAX_VALUE).array()).build())).build();
        byte[] bytes = this.codec().writeSpan(span);
        Assertions.assertThat((Comparable)this.codec().readSpan(bytes)).isEqualTo((Object)span);
    }

    @Test
    public void specialCharsInJson() throws IOException {
        Endpoint e = Endpoint.create((String)new String(new char[]{'\u0000', 'a', '\u0001'}), (int)0);
        Span worstSpanInTheWorld = Span.builder().traceId(1L).id(1L).name(new String(new char[]{'\"', '\\', '\t', '\b', '\n', '\r', '\f'})).addAnnotation(Annotation.create((long)1L, (String)"\u2028 and \u2029", (Endpoint)e)).addBinaryAnnotation(BinaryAnnotation.create((String)"\"foo", (String)"Database error: ORA-00942:\u2028 and \u2029 table or view does not exist\n", (Endpoint)e)).build();
        byte[] bytes = this.codec().writeSpan(worstSpanInTheWorld);
        Assertions.assertThat((Comparable)this.codec().readSpan(bytes)).isEqualTo((Object)worstSpanInTheWorld);
    }

    @Test
    public void binaryAnnotation_double() throws IOException {
        Span span = TestObjects.LOTS_OF_SPANS[0].toBuilder().binaryAnnotations(Arrays.asList(BinaryAnnotation.builder().key("Double.zero").type(BinaryAnnotation.Type.DOUBLE).value(ByteBuffer.allocate(8).putDouble(0, 0.0).array()).build(), BinaryAnnotation.builder().key("Double.negative").type(BinaryAnnotation.Type.DOUBLE).value(ByteBuffer.allocate(8).putDouble(0, -1.0056566795884392).array()).build(), BinaryAnnotation.builder().key("Double.MIN_VALUE").type(BinaryAnnotation.Type.DOUBLE).value(ByteBuffer.allocate(8).putDouble(0, Double.MIN_VALUE).array()).build(), BinaryAnnotation.builder().key("Double.MAX_VALUE").type(BinaryAnnotation.Type.I64).value(ByteBuffer.allocate(8).putDouble(0, Double.MAX_VALUE).array()).build())).build();
        byte[] bytes = this.codec().writeSpan(span);
        Assertions.assertThat((Comparable)this.codec().readSpan(bytes)).isEqualTo((Object)span);
    }

    @Test
    public void spansRoundTrip() throws IOException {
        byte[] bytes = this.codec().writeSpans(TestObjects.TRACE);
        Assertions.assertThat((List)this.codec().readSpans(bytes)).isEqualTo(TestObjects.TRACE);
    }

    @Test
    public void writeTraces() throws IOException {
        byte[] bytes = this.codec().writeTraces(Arrays.asList(TestObjects.TRACE, TestObjects.TRACE));
        Assertions.assertThat((int)(this.codec().writeSpans(TestObjects.TRACE).length * 2)).isLessThan(bytes.length);
    }

    @Test
    public void dependencyLinkRoundTrip() throws IOException {
        DependencyLink link = DependencyLink.create((String)"foo", (String)"bar", (long)2L);
        byte[] bytes = this.codec().writeDependencyLink(link);
        Assertions.assertThat((Object)this.codec().readDependencyLink(bytes)).isEqualTo((Object)link);
    }

    @Test
    public void dependencyLinksRoundTrip() throws IOException {
        List<DependencyLink> links = Arrays.asList(DependencyLink.create((String)"foo", (String)"bar", (long)2L), DependencyLink.create((String)"bar", (String)"baz", (long)3L));
        byte[] bytes = this.codec().writeDependencyLinks(links);
        Assertions.assertThat((List)this.codec().readDependencyLinks(bytes)).isEqualTo(links);
    }

    @Test
    public void decentErrorMessageOnEmptyInput_span() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Empty input reading Span");
        this.codec().readSpan(new byte[0]);
    }

    @Test
    public void decentErrorMessageOnEmptyInput_spans() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Empty input reading List<Span>");
        this.codec().readSpans(new byte[0]);
    }

    @Test
    public void decentErrorMessageOnEmptyInput_dependencyLinks() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Empty input reading List<DependencyLink>");
        this.codec().readDependencyLinks(new byte[0]);
    }

    @Test
    public void decentErrorMessageOnMalformedInput_span() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Malformed reading Span from ");
        this.codec().readSpan(new byte[]{104, 101, 108, 108, 111});
    }

    @Test
    public void decentErrorMessageOnMalformedInput_spans() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Malformed reading List<Span> from ");
        this.codec().readSpans(new byte[]{104, 101, 108, 108, 111});
    }

    @Test
    public void decentErrorMessageOnMalformedInput_dependencyLinks() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Malformed reading List<DependencyLink> from ");
        this.codec().readDependencyLinks(new byte[]{104, 101, 108, 108, 111});
    }
}

