/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class DependencyLinkSpan {
    final Kind kind;
    @Nullable
    final Long parentId;
    final long id;
    @Nullable
    final String service;
    @Nullable
    final String peerService;

    DependencyLinkSpan(Kind kind, Long parentId, long id, String service, String peerService) {
        this.kind = Util.checkNotNull(kind, "kind");
        this.parentId = parentId;
        this.id = id;
        this.service = service;
        this.peerService = peerService;
    }

    public String toString() {
        StringBuilder json = new StringBuilder("{\"kind\": \"").append((Object)this.kind).append('\"');
        if (this.parentId != null) {
            json.append(", \"parentId\": \"").append(Util.toLowerHex(this.parentId)).append('\"');
        }
        json.append(", \"id\": \"").append(Util.toLowerHex(this.id)).append('\"');
        if (this.service != null) {
            json.append(", \"service\": \"").append(this.service).append('\"');
        }
        if (this.peerService != null) {
            json.append(", \"peerService\": \"").append(this.peerService).append('\"');
        }
        return json.append("}").toString();
    }

    public static Builder builder(Long parentId, long spanId) {
        return new Builder(parentId, spanId);
    }

    public static final class Builder {
        private final Long parentId;
        private final long spanId;
        private String srService;
        private String caService;
        private String saService;

        Builder(Long parentId, long spanId) {
            this.spanId = spanId;
            this.parentId = parentId;
        }

        public Builder srService(String srService) {
            this.srService = srService;
            return this;
        }

        public Builder caService(String caService) {
            this.caService = caService;
            return this;
        }

        public Builder saService(String saService) {
            this.saService = saService;
            return this;
        }

        public DependencyLinkSpan build() {
            if (Util.equal(this.saService, this.caService)) {
                this.caService = null;
            }
            if (this.srService != null) {
                return new DependencyLinkSpan(Kind.SERVER, this.parentId, this.spanId, this.srService, this.caService);
            }
            if (this.saService != null) {
                return new DependencyLinkSpan(Kind.CLIENT, this.parentId, this.spanId, this.caService, this.saService);
            }
            return new DependencyLinkSpan(Kind.UNKNOWN, this.parentId, this.spanId, null, null);
        }
    }

    static enum Kind {
        CLIENT,
        SERVER,
        UNKNOWN;

    }
}

