/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.concurrent.Executor;
import zipkin.Component;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.InMemorySpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;

public final class InMemoryStorage
implements StorageComponent {
    final InMemorySpanStore spanStore = new InMemorySpanStore();
    final Executor callingThread = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    final AsyncSpanStore asyncSpanStore = StorageAdapters.blockingToAsync(this.spanStore, this.callingThread);
    final AsyncSpanConsumer asyncConsumer;

    public InMemoryStorage() {
        this.asyncConsumer = StorageAdapters.blockingToAsync(this.spanStore.spanConsumer, this.callingThread);
    }

    @Override
    public InMemorySpanStore spanStore() {
        return this.spanStore;
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public StorageAdapters.SpanConsumer spanConsumer() {
        return this.spanStore.spanConsumer;
    }

    @Override
    public AsyncSpanConsumer asyncSpanConsumer() {
        return this.asyncConsumer;
    }

    public void clear() {
        this.spanStore.clear();
    }

    public int acceptedSpanCount() {
        return this.spanStore.acceptedSpanCount;
    }

    @Override
    public Component.CheckResult check() {
        return Component.CheckResult.OK;
    }

    @Override
    public void close() {
    }
}

