/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import zipkin.internal.moshi.Json;
import zipkin.internal.moshi.JsonAdapter;
import zipkin.internal.moshi.JsonDataException;
import zipkin.internal.moshi.JsonReader;
import zipkin.internal.moshi.JsonWriter;
import zipkin.internal.moshi.LinkedHashTreeMap;
import zipkin.internal.moshi.Moshi;
import zipkin.internal.moshi.Types;
import zipkin.internal.moshi.Util;

final class StandardJsonAdapters {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            if (type == Boolean.TYPE) {
                return BOOLEAN_JSON_ADAPTER;
            }
            if (type == Byte.TYPE) {
                return BYTE_JSON_ADAPTER;
            }
            if (type == Character.TYPE) {
                return CHARACTER_JSON_ADAPTER;
            }
            if (type == Double.TYPE) {
                return DOUBLE_JSON_ADAPTER;
            }
            if (type == Float.TYPE) {
                return FLOAT_JSON_ADAPTER;
            }
            if (type == Integer.TYPE) {
                return INTEGER_JSON_ADAPTER;
            }
            if (type == Long.TYPE) {
                return LONG_JSON_ADAPTER;
            }
            if (type == Short.TYPE) {
                return SHORT_JSON_ADAPTER;
            }
            if (type == Boolean.class) {
                return BOOLEAN_JSON_ADAPTER.nullSafe();
            }
            if (type == Byte.class) {
                return BYTE_JSON_ADAPTER.nullSafe();
            }
            if (type == Character.class) {
                return CHARACTER_JSON_ADAPTER.nullSafe();
            }
            if (type == Double.class) {
                return DOUBLE_JSON_ADAPTER.nullSafe();
            }
            if (type == Float.class) {
                return FLOAT_JSON_ADAPTER.nullSafe();
            }
            if (type == Integer.class) {
                return INTEGER_JSON_ADAPTER.nullSafe();
            }
            if (type == Long.class) {
                return LONG_JSON_ADAPTER.nullSafe();
            }
            if (type == Short.class) {
                return SHORT_JSON_ADAPTER.nullSafe();
            }
            if (type == String.class) {
                return STRING_JSON_ADAPTER.nullSafe();
            }
            if (type == Object.class) {
                return new ObjectJsonAdapter(moshi).nullSafe();
            }
            Class<?> rawType = Types.getRawType(type);
            if (rawType.isEnum()) {
                return new EnumJsonAdapter(rawType).nullSafe();
            }
            return null;
        }
    };
    private static final String ERROR_FORMAT = "Expected %s but was %s at path %s";
    static final JsonAdapter<Boolean> BOOLEAN_JSON_ADAPTER = new JsonAdapter<Boolean>(){

        @Override
        public Boolean fromJson(JsonReader reader) throws IOException {
            return reader.nextBoolean();
        }

        @Override
        public void toJson(JsonWriter writer, Boolean value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Boolean)";
        }
    };
    static final JsonAdapter<Byte> BYTE_JSON_ADAPTER = new JsonAdapter<Byte>(){

        @Override
        public Byte fromJson(JsonReader reader) throws IOException {
            return (byte)StandardJsonAdapters.rangeCheckNextInt(reader, "a byte", -128, 255);
        }

        @Override
        public void toJson(JsonWriter writer, Byte value) throws IOException {
            writer.value(value.intValue() & 0xFF);
        }

        public String toString() {
            return "JsonAdapter(Byte)";
        }
    };
    static final JsonAdapter<Character> CHARACTER_JSON_ADAPTER = new JsonAdapter<Character>(){

        @Override
        public Character fromJson(JsonReader reader) throws IOException {
            String value = reader.nextString();
            if (value.length() > 1) {
                throw new JsonDataException(String.format(StandardJsonAdapters.ERROR_FORMAT, "a char", '\"' + value + '\"', reader.getPath()));
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public void toJson(JsonWriter writer, Character value) throws IOException {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Character)";
        }
    };
    static final JsonAdapter<Double> DOUBLE_JSON_ADAPTER = new JsonAdapter<Double>(){

        @Override
        public Double fromJson(JsonReader reader) throws IOException {
            return reader.nextDouble();
        }

        @Override
        public void toJson(JsonWriter writer, Double value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Double)";
        }
    };
    static final JsonAdapter<Float> FLOAT_JSON_ADAPTER = new JsonAdapter<Float>(){

        @Override
        public Float fromJson(JsonReader reader) throws IOException {
            float value = (float)reader.nextDouble();
            if (!reader.isLenient() && Float.isInfinite(value)) {
                throw new JsonDataException("JSON forbids NaN and infinities: " + value + " at path " + reader.getPath());
            }
            return Float.valueOf(value);
        }

        @Override
        public void toJson(JsonWriter writer, Float value) throws IOException {
            if (value == null) {
                throw new NullPointerException();
            }
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Float)";
        }
    };
    static final JsonAdapter<Integer> INTEGER_JSON_ADAPTER = new JsonAdapter<Integer>(){

        @Override
        public Integer fromJson(JsonReader reader) throws IOException {
            return reader.nextInt();
        }

        @Override
        public void toJson(JsonWriter writer, Integer value) throws IOException {
            writer.value(value.intValue());
        }

        public String toString() {
            return "JsonAdapter(Integer)";
        }
    };
    static final JsonAdapter<Long> LONG_JSON_ADAPTER = new JsonAdapter<Long>(){

        @Override
        public Long fromJson(JsonReader reader) throws IOException {
            return reader.nextLong();
        }

        @Override
        public void toJson(JsonWriter writer, Long value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Long)";
        }
    };
    static final JsonAdapter<Short> SHORT_JSON_ADAPTER = new JsonAdapter<Short>(){

        @Override
        public Short fromJson(JsonReader reader) throws IOException {
            return (short)StandardJsonAdapters.rangeCheckNextInt(reader, "a short", Short.MIN_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void toJson(JsonWriter writer, Short value) throws IOException {
            writer.value(value.intValue());
        }

        public String toString() {
            return "JsonAdapter(Short)";
        }
    };
    static final JsonAdapter<String> STRING_JSON_ADAPTER = new JsonAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        @Override
        public void toJson(JsonWriter writer, String value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(String)";
        }
    };

    StandardJsonAdapters() {
    }

    static int rangeCheckNextInt(JsonReader reader, String typeMessage, int min, int max) throws IOException {
        int value = reader.nextInt();
        if (value < min || value > max) {
            throw new JsonDataException(String.format(ERROR_FORMAT, typeMessage, value, reader.getPath()));
        }
        return value;
    }

    static final class ObjectJsonAdapter
    extends JsonAdapter<Object> {
        private final Moshi moshi;

        public ObjectJsonAdapter(Moshi moshi) {
            this.moshi = moshi;
        }

        @Override
        public Object fromJson(JsonReader reader) throws IOException {
            switch (reader.peek()) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    reader.beginArray();
                    while (reader.hasNext()) {
                        list.add(this.fromJson(reader));
                    }
                    reader.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    LinkedHashTreeMap<String, Object> map = new LinkedHashTreeMap<String, Object>();
                    reader.beginObject();
                    while (reader.hasNext()) {
                        map.put(reader.nextName(), this.fromJson(reader));
                    }
                    reader.endObject();
                    return map;
                }
                case STRING: {
                    return reader.nextString();
                }
                case NUMBER: {
                    return reader.nextDouble();
                }
                case BOOLEAN: {
                    return reader.nextBoolean();
                }
                case NULL: {
                    return reader.nextNull();
                }
            }
            throw new IllegalStateException("Expected a value but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
        }

        @Override
        public void toJson(JsonWriter writer, Object value) throws IOException {
            Class<?> valueClass = value.getClass();
            if (valueClass == Object.class) {
                writer.beginObject();
                writer.endObject();
            } else {
                this.moshi.adapter(this.toJsonType(valueClass), Util.NO_ANNOTATIONS).toJson(writer, value);
            }
        }

        private Class<?> toJsonType(Class<?> valueClass) {
            if (Map.class.isAssignableFrom(valueClass)) {
                return Map.class;
            }
            if (Collection.class.isAssignableFrom(valueClass)) {
                return Collection.class;
            }
            return valueClass;
        }

        public String toString() {
            return "JsonAdapter(Object)";
        }
    }

    static final class EnumJsonAdapter<T extends Enum<T>>
    extends JsonAdapter<T> {
        private final Class<T> enumType;
        private final Map<String, T> nameConstantMap;
        private final String[] nameStrings;

        public EnumJsonAdapter(Class<T> enumType) {
            this.enumType = enumType;
            try {
                Enum[] constants = (Enum[])enumType.getEnumConstants();
                this.nameConstantMap = new LinkedHashMap<String, T>();
                this.nameStrings = new String[constants.length];
                for (int i = 0; i < constants.length; ++i) {
                    Enum constant = constants[i];
                    Json annotation = enumType.getField(constant.name()).getAnnotation(Json.class);
                    String name = annotation != null ? annotation.name() : constant.name();
                    this.nameConstantMap.put(name, constant);
                    this.nameStrings[i] = name;
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError("Missing field in " + enumType.getName(), e);
            }
        }

        @Override
        public T fromJson(JsonReader reader) throws IOException {
            String name = reader.nextString();
            Enum constant = (Enum)this.nameConstantMap.get(name);
            if (constant != null) {
                return (T)constant;
            }
            throw new JsonDataException("Expected one of " + this.nameConstantMap.keySet() + " but was " + name + " at path " + reader.getPath());
        }

        @Override
        public void toJson(JsonWriter writer, T value) throws IOException {
            writer.value(this.nameStrings[((Enum)value).ordinal()]);
        }

        public String toString() {
            return "JsonAdapter(" + this.enumType.getName() + ")";
        }
    }
}

