/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Node;
import zipkin.internal.Nullable;

public final class CorrectForClockSkew {
    public static List<Span> apply(List<Span> spans) {
        for (Span s : spans) {
            if (s.parentId != null) continue;
            Node<Span> tree = Node.constructTree(spans);
            CorrectForClockSkew.adjust(tree, null);
            ArrayList<Span> result = new ArrayList<Span>(spans.size());
            Iterator<Node<Span>> i = tree.traverse();
            while (i.hasNext()) {
                result.add(i.next().value());
            }
            return result;
        }
        return spans;
    }

    static void adjust(Node<Span> node, @Nullable ClockSkew skewFromParent) {
        ClockSkew skew;
        if (skewFromParent != null) {
            node.value(CorrectForClockSkew.adjustTimestamps(node.value(), skewFromParent));
        }
        if ((skew = CorrectForClockSkew.getClockSkew(node.value())) != null) {
            node.value(CorrectForClockSkew.adjustTimestamps(node.value(), skew));
            for (Node<Span> child : node.children()) {
                CorrectForClockSkew.adjust(child, skew);
            }
        }
    }

    static Span adjustTimestamps(Span span, ClockSkew skew) {
        int i;
        ArrayList<Annotation> annotations = null;
        int length = span.annotations.size();
        for (i = 0; i < length; ++i) {
            Annotation a = span.annotations.get(i);
            if (a.endpoint == null || skew.endpoint.ipv4 != a.endpoint.ipv4) continue;
            if (annotations == null) {
                annotations = new ArrayList<Annotation>(span.annotations);
            }
            annotations.set(i, a.toBuilder().timestamp(a.timestamp - skew.skew).build());
        }
        if (annotations != null) {
            return span.toBuilder().timestamp(((Annotation)annotations.get((int)0)).timestamp).annotations((Collection<Annotation>)annotations).build();
        }
        length = span.binaryAnnotations.size();
        for (i = 0; i < length; ++i) {
            BinaryAnnotation b = span.binaryAnnotations.get(i);
            if (b.endpoint == null || !b.key.equals("lc") || skew.endpoint.ipv4 != b.endpoint.ipv4) continue;
            return span.toBuilder().timestamp(span.timestamp - skew.skew).build();
        }
        return span;
    }

    @Nullable
    static ClockSkew getClockSkew(Span span) {
        boolean crAhead;
        Map<String, Annotation> annotations = CorrectForClockSkew.asMap(span.annotations);
        Long clientSend = CorrectForClockSkew.getTimestamp(annotations, "cs");
        Long clientRecv = CorrectForClockSkew.getTimestamp(annotations, "cr");
        Long serverRecv = CorrectForClockSkew.getTimestamp(annotations, "sr");
        Long serverSend = CorrectForClockSkew.getTimestamp(annotations, "ss");
        if (clientSend == null || clientRecv == null || serverRecv == null || serverSend == null) {
            return null;
        }
        Endpoint server = annotations.get((Object)"sr").endpoint;
        Endpoint endpoint = server = server == null ? annotations.get((Object)"ss").endpoint : server;
        if (server == null) {
            return null;
        }
        long clientDuration = clientRecv - clientSend;
        long serverDuration = serverSend - serverRecv;
        boolean csAhead = clientSend < serverRecv;
        boolean bl = crAhead = clientRecv > serverSend;
        if (serverDuration > clientDuration || csAhead && crAhead) {
            return null;
        }
        long latency = (clientDuration - serverDuration) / 2L;
        long skew = serverRecv - latency - clientSend;
        if (skew != 0L) {
            return new ClockSkew(server, skew);
        }
        return null;
    }

    static Map<String, Annotation> asMap(List<Annotation> annotations) {
        LinkedHashMap<String, Annotation> result = new LinkedHashMap<String, Annotation>(annotations.size());
        for (Annotation a : annotations) {
            result.put(a.value, a);
        }
        return result;
    }

    @Nullable
    static Long getTimestamp(Map<String, Annotation> annotations, String value) {
        Annotation result = annotations.get(value);
        return result != null ? Long.valueOf(result.timestamp) : null;
    }

    private CorrectForClockSkew() {
    }

    static class ClockSkew {
        final Endpoint endpoint;
        final long skew;

        public ClockSkew(Endpoint endpoint, long skew) {
            this.endpoint = endpoint;
            this.skew = skew;
        }
    }
}

