/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.servlet;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.servlet.ServletHttpServerRequest;
import com.github.kristofa.brave.servlet.internal.MaybeAddClientAddressFromRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BraveServletFilter
implements Filter {
    private final ServerRequestInterceptor requestInterceptor;
    private final ServerResponseInterceptor responseInterceptor;
    private final SpanNameProvider spanNameProvider;
    @Nullable
    private final ServerTracer serverTracer;
    private final MaybeAddClientAddressFromRequest maybeAddClientAddressFromRequest;
    private FilterConfig filterConfig;

    public static BraveServletFilter create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    protected BraveServletFilter(Builder b) {
        this.requestInterceptor = b.brave.serverRequestInterceptor();
        this.responseInterceptor = b.brave.serverResponseInterceptor();
        this.spanNameProvider = b.spanNameProvider;
        this.serverTracer = b.brave.serverTracer();
        this.maybeAddClientAddressFromRequest = MaybeAddClientAddressFromRequest.create(b.brave);
    }

    @Deprecated
    public BraveServletFilter(ServerRequestInterceptor requestInterceptor, ServerResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.spanNameProvider = spanNameProvider;
        this.serverTracer = null;
        this.maybeAddClientAddressFromRequest = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean hasAlreadyFilteredAttribute;
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
        } else {
            request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Servlet25ServerResponseAdapter servlet25ServerResponseAdapter = new Servlet25ServerResponseAdapter((HttpServletResponse)response);
            this.requestInterceptor.handle((ServerRequestAdapter)new HttpServerRequestAdapter((HttpServerRequest)new ServletHttpServerRequest(httpRequest), this.spanNameProvider));
            if (this.maybeAddClientAddressFromRequest != null) {
                this.maybeAddClientAddressFromRequest.accept(httpRequest);
            }
            try {
                filterChain.doFilter(request, (ServletResponse)servlet25ServerResponseAdapter);
            }
            catch (IOException | Error | RuntimeException | ServletException e) {
                if (this.serverTracer != null) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = e.getClass().getSimpleName();
                    }
                    this.serverTracer.submitBinaryAnnotation("error", message);
                }
                throw e;
            }
            finally {
                this.responseInterceptor.handle((ServerResponseAdapter)servlet25ServerResponseAdapter);
            }
        }
    }

    public void destroy() {
    }

    private String getAlreadyFilteredAttributeName() {
        String name = this.getFilterName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ".FILTERED";
    }

    private final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : null;
    }

    static final class Servlet25ServerResponseAdapter
    extends HttpServletResponseWrapper
    implements ServerResponseAdapter {
        int httpStatus = 200;

        Servlet25ServerResponseAdapter(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public Collection<KeyValueAnnotation> responseAnnotations() {
            return Collections.singleton(KeyValueAnnotation.create((String)"http.status_code", (String)String.valueOf(this.httpStatus)));
        }
    }

    public static final class Builder {
        final Brave brave;
        SpanNameProvider spanNameProvider = new DefaultSpanNameProvider();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder spanNameProvider(SpanNameProvider spanNameProvider) {
            this.spanNameProvider = (SpanNameProvider)Util.checkNotNull((Object)spanNameProvider, (String)"spanNameProvider", (Object[])new Object[0]);
            return this;
        }

        public BraveServletFilter build() {
            return new BraveServletFilter(this);
        }
    }
}

