/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.servlet;

import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.HttpServerResponseAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.servlet.ServletHttpServerRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BraveServletFilter
implements Filter {
    private final ServerRequestInterceptor requestInterceptor;
    private final ServerResponseInterceptor responseInterceptor;
    private final SpanNameProvider spanNameProvider;
    private FilterConfig filterConfig;

    public BraveServletFilter(ServerRequestInterceptor requestInterceptor, ServerResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.spanNameProvider = spanNameProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean hasAlreadyFilteredAttribute;
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
            return;
        }
        StatusExposingServletResponse statusExposingServletResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.requestInterceptor.handle((ServerRequestAdapter)new HttpServerRequestAdapter((HttpServerRequest)new ServletHttpServerRequest((HttpServletRequest)request), this.spanNameProvider));
        try {
            filterChain.doFilter(request, (ServletResponse)statusExposingServletResponse);
        }
        catch (Throwable throwable) {
            this.responseInterceptor.handle((ServerResponseAdapter)new HttpServerResponseAdapter(new HttpResponse(statusExposingServletResponse){
                final /* synthetic */ StatusExposingServletResponse val$statusExposingServletResponse;
                {
                    this.val$statusExposingServletResponse = statusExposingServletResponse;
                }

                public int getHttpStatusCode() {
                    return this.val$statusExposingServletResponse.getStatus();
                }
            }));
            throw throwable;
        }
        this.responseInterceptor.handle((ServerResponseAdapter)new HttpServerResponseAdapter(new /* invalid duplicate definition of identical inner class */));
    }

    public void destroy() {
    }

    private String getAlreadyFilteredAttributeName() {
        String name = this.getFilterName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ".FILTERED";
    }

    private final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : null;
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

