/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.spring;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.HttpServerResponseAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.servlet.ServletHttpServerRequest;
import com.github.kristofa.brave.servlet.internal.MaybeAddClientAddressFromRequest;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Deprecated
@Configuration
public class ServletHandlerInterceptor
extends HandlerInterceptorAdapter {
    static final String HTTP_SERVER_SPAN_ATTRIBUTE = ServletHandlerInterceptor.class.getName() + ".server-span";
    private final ServerRequestInterceptor requestInterceptor;
    private final ServerResponseInterceptor responseInterceptor;
    private final ServerSpanThreadBinder serverThreadBinder;
    private final SpanNameProvider spanNameProvider;
    @Nullable
    private final ServerTracer serverTracer;
    private final MaybeAddClientAddressFromRequest maybeAddClientAddressFromRequest;

    public static ServletHandlerInterceptor create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    @Autowired
    ServletHandlerInterceptor(SpanNameProvider spanNameProvider, Brave brave) {
        this(ServletHandlerInterceptor.builder(brave).spanNameProvider(spanNameProvider));
    }

    ServletHandlerInterceptor(Builder b) {
        this.requestInterceptor = b.brave.serverRequestInterceptor();
        this.responseInterceptor = b.brave.serverResponseInterceptor();
        this.serverThreadBinder = b.brave.serverSpanThreadBinder();
        this.spanNameProvider = b.spanNameProvider;
        this.serverTracer = b.brave.serverTracer();
        this.maybeAddClientAddressFromRequest = MaybeAddClientAddressFromRequest.create((Brave)b.brave);
    }

    @Deprecated
    public ServletHandlerInterceptor(ServerRequestInterceptor requestInterceptor, ServerResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider, ServerSpanThreadBinder serverThreadBinder) {
        this.requestInterceptor = requestInterceptor;
        this.spanNameProvider = spanNameProvider;
        this.responseInterceptor = responseInterceptor;
        this.serverThreadBinder = serverThreadBinder;
        this.serverTracer = null;
        this.maybeAddClientAddressFromRequest = null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (request.getAttribute(HTTP_SERVER_SPAN_ATTRIBUTE) != null) {
            return true;
        }
        this.requestInterceptor.handle((ServerRequestAdapter)new HttpServerRequestAdapter((HttpServerRequest)new ServletHttpServerRequest(request), this.spanNameProvider));
        if (this.maybeAddClientAddressFromRequest != null) {
            this.maybeAddClientAddressFromRequest.accept((Object)request);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute(HTTP_SERVER_SPAN_ATTRIBUTE, (Object)this.serverThreadBinder.getCurrentServerSpan());
        this.serverThreadBinder.setCurrentSpan(ServerSpan.EMPTY);
    }

    public void afterCompletion(HttpServletRequest request, final HttpServletResponse response, Object handler, Exception ex) {
        ServerSpan span = (ServerSpan)request.getAttribute(HTTP_SERVER_SPAN_ATTRIBUTE);
        if (span != null) {
            this.serverThreadBinder.setCurrentSpan(span);
        }
        if (this.serverTracer != null && ex != null) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.getClass().getSimpleName();
            }
            this.serverTracer.submitBinaryAnnotation("error", message);
        }
        this.responseInterceptor.handle((ServerResponseAdapter)new HttpServerResponseAdapter(new HttpResponse(){

            public int getHttpStatusCode() {
                return response.getStatus();
            }
        }));
    }

    public static final class Builder {
        final Brave brave;
        SpanNameProvider spanNameProvider = new DefaultSpanNameProvider();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder spanNameProvider(SpanNameProvider spanNameProvider) {
            this.spanNameProvider = (SpanNameProvider)Util.checkNotNull((Object)spanNameProvider, (String)"spanNameProvider", (Object[])new Object[0]);
            return this;
        }

        public ServletHandlerInterceptor build() {
            return new ServletHandlerInterceptor(this);
        }
    }
}

