/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.spring;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.NoAnnotationsClientResponseAdapter;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpClientRequest;
import com.github.kristofa.brave.http.HttpClientRequestAdapter;
import com.github.kristofa.brave.http.HttpClientResponseAdapter;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.spring.SpringHttpClientRequest;
import com.github.kristofa.brave.spring.SpringHttpResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class BraveClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final ClientRequestInterceptor requestInterceptor;
    private final ClientResponseInterceptor responseInterceptor;
    private final SpanNameProvider spanNameProvider;

    public static BraveClientHttpRequestInterceptor create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    BraveClientHttpRequestInterceptor(Builder b) {
        this.requestInterceptor = b.brave.clientRequestInterceptor();
        this.responseInterceptor = b.brave.clientResponseInterceptor();
        this.spanNameProvider = b.spanNameProvider;
    }

    @Autowired
    BraveClientHttpRequestInterceptor(SpanNameProvider spanNameProvider, Brave brave) {
        this(BraveClientHttpRequestInterceptor.builder(brave).spanNameProvider(spanNameProvider));
    }

    @Deprecated
    public BraveClientHttpRequestInterceptor(ClientRequestInterceptor requestInterceptor, ClientResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.spanNameProvider = spanNameProvider;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response;
        this.requestInterceptor.handle((ClientRequestAdapter)new HttpClientRequestAdapter((HttpClientRequest)new SpringHttpClientRequest(request), this.spanNameProvider));
        try {
            response = execution.execute(request, body);
        }
        catch (IOException | RuntimeException up) {
            this.responseInterceptor.handle(NoAnnotationsClientResponseAdapter.getInstance());
            throw up;
        }
        try {
            this.responseInterceptor.handle((ClientResponseAdapter)new HttpClientResponseAdapter((HttpResponse)new SpringHttpResponse(response.getRawStatusCode())));
        }
        catch (IOException | RuntimeException up) {
            this.responseInterceptor.handle(NoAnnotationsClientResponseAdapter.getInstance());
        }
        return response;
    }

    public static final class Builder {
        final Brave brave;
        SpanNameProvider spanNameProvider = new DefaultSpanNameProvider();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder spanNameProvider(SpanNameProvider spanNameProvider) {
            this.spanNameProvider = (SpanNameProvider)Util.checkNotNull((Object)spanNameProvider, (String)"spanNameProvider", (Object[])new Object[0]);
            return this;
        }

        public BraveClientHttpRequestInterceptor build() {
            return new BraveClientHttpRequestInterceptor(this);
        }
    }
}

