/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.okhttp;

import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.http.HttpClientRequest;
import com.github.kristofa.brave.http.HttpClientRequestAdapter;
import com.github.kristofa.brave.http.HttpClientResponseAdapter;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.okhttp.OkHttpRequest;
import com.github.kristofa.brave.okhttp.OkHttpResponse;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BraveOkHttpRequestResponseInterceptor
implements Interceptor {
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final SpanNameProvider spanNameProvider;

    public BraveOkHttpRequestResponseInterceptor(ClientRequestInterceptor requestInterceptor, ClientResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.spanNameProvider = spanNameProvider;
        this.clientRequestInterceptor = requestInterceptor;
        this.clientResponseInterceptor = responseInterceptor;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        OkHttpRequest okHttpRequest = new OkHttpRequest(builder, request);
        this.clientRequestInterceptor.handle((ClientRequestAdapter)new HttpClientRequestAdapter((HttpClientRequest)okHttpRequest, this.spanNameProvider));
        Response response = chain.proceed(builder.build());
        this.clientResponseInterceptor.handle((ClientResponseAdapter)new HttpClientResponseAdapter((HttpResponse)new OkHttpResponse(response)));
        return response;
    }
}

