/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.http;

import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceData;
import com.github.kristofa.brave.http.BraveHttpHeaders;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.SpanNameProvider;
import java.util.Collection;
import java.util.Collections;

public class HttpServerRequestAdapter
implements ServerRequestAdapter {
    private final HttpServerRequest serverRequest;
    private final SpanNameProvider spanNameProvider;

    public HttpServerRequestAdapter(HttpServerRequest serverRequest, SpanNameProvider spanNameProvider) {
        this.serverRequest = serverRequest;
        this.spanNameProvider = spanNameProvider;
    }

    public TraceData getTraceData() {
        String sampled = this.serverRequest.getHttpHeaderValue(BraveHttpHeaders.Sampled.getName());
        if (sampled != null) {
            if (sampled.equals("0") || sampled.toLowerCase().equals("false")) {
                return TraceData.builder().sample(Boolean.valueOf(false)).build();
            }
            String parentSpanId = this.serverRequest.getHttpHeaderValue(BraveHttpHeaders.ParentSpanId.getName());
            String traceId = this.serverRequest.getHttpHeaderValue(BraveHttpHeaders.TraceId.getName());
            String spanId = this.serverRequest.getHttpHeaderValue(BraveHttpHeaders.SpanId.getName());
            if (traceId != null && spanId != null) {
                SpanId span = this.getSpanId(traceId, spanId, parentSpanId);
                return TraceData.builder().sample(Boolean.valueOf(true)).spanId(span).build();
            }
        }
        return TraceData.builder().build();
    }

    public String getSpanName() {
        return this.spanNameProvider.spanName(this.serverRequest);
    }

    public Collection<KeyValueAnnotation> requestAnnotations() {
        KeyValueAnnotation uriAnnotation = KeyValueAnnotation.create((String)"http.url", (String)this.serverRequest.getUri().toString());
        return Collections.singleton(uriAnnotation);
    }

    private SpanId getSpanId(String traceId, String spanId, String parentSpanId) {
        return SpanId.builder().traceId(IdConversion.convertToLong((String)traceId)).spanId(IdConversion.convertToLong((String)spanId)).parentId(parentSpanId == null ? null : Long.valueOf(IdConversion.convertToLong((String)parentSpanId))).build();
    }
}

