/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.internal.InetAddresses;
import com.github.kristofa.brave.internal.Internal;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public abstract class MaybeAddClientAddress<T> {
    final Brave brave;

    protected MaybeAddClientAddress(Brave brave) {
        this.brave = Util.checkNotNull(brave, "brave", new Object[0]);
    }

    public final void accept(T input) {
        byte[] addressBytes;
        Span span;
        ServerSpan serverSpan = this.brave.serverSpanThreadBinder().getCurrentServerSpan();
        Span span2 = span = serverSpan != null ? serverSpan.getSpan() : null;
        if (span == null) {
            return;
        }
        try {
            addressBytes = this.parseAddressBytes(input);
            if (addressBytes == null) {
                return;
            }
        }
        catch (RuntimeException e) {
            return;
        }
        Endpoint.Builder builder = Endpoint.builder().serviceName("");
        if (addressBytes.length == 4) {
            builder.ipv4(ByteBuffer.wrap(addressBytes).getInt());
        } else if (addressBytes.length == 16) {
            builder.ipv6(addressBytes);
        } else {
            return;
        }
        try {
            int port = this.parsePort(input);
            if (port > 0) {
                builder.port(port);
            }
        }
        catch (RuntimeException port) {
            // empty catch block
        }
        Endpoint ca = builder.build();
        Internal.instance.setClientAddress(this.brave, ca);
    }

    protected abstract byte[] parseAddressBytes(T var1);

    protected abstract int parsePort(T var1);

    @Nullable
    protected byte[] ipStringToBytes(String ipString) {
        return InetAddresses.ipStringToBytes(ipString);
    }
}

