/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

public abstract class CorrelationFieldScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    @Override
    public CurrentTraceContext.Scope decorateScope(@Nullable TraceContext currentSpan, final CurrentTraceContext.Scope scope) {
        final String previousTraceId = this.get("traceId");
        final String previousSpanId = this.get("spanId");
        final String previousParentId = this.get("parentId");
        if (currentSpan != null) {
            this.maybeReplaceTraceContext(currentSpan, previousTraceId, previousParentId, previousSpanId);
        } else {
            this.remove("traceId");
            this.remove("parentId");
            this.remove("spanId");
        }
        class CorrelationFieldCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            CorrelationFieldCurrentTraceContextScope() {
            }

            @Override
            public void close() {
                scope.close();
                CorrelationFieldScopeDecorator.this.replace("traceId", previousTraceId);
                CorrelationFieldScopeDecorator.this.replace("parentId", previousParentId);
                CorrelationFieldScopeDecorator.this.replace("spanId", previousSpanId);
            }
        }
        return new CorrelationFieldCurrentTraceContextScope();
    }

    void maybeReplaceTraceContext(TraceContext currentSpan, String previousTraceId, @Nullable String previousParentId, String previousSpanId) {
        long parentId;
        boolean sameTraceId = HexCodec.lowerHexEqualsTraceId(previousTraceId, currentSpan);
        if (!sameTraceId) {
            this.put("traceId", currentSpan.traceIdString());
        }
        if ((parentId = currentSpan.parentIdAsLong()) == 0L) {
            this.remove("parentId");
        } else {
            boolean sameParentId = HexCodec.lowerHexEqualsUnsignedLong(previousParentId, parentId);
            if (!sameParentId) {
                this.put("parentId", HexCodec.toLowerHex(parentId));
            }
        }
        boolean sameSpanId = HexCodec.lowerHexEqualsUnsignedLong(previousSpanId, currentSpan.spanId());
        if (!sameSpanId) {
            this.put("spanId", HexCodec.toLowerHex(currentSpan.spanId()));
        }
    }

    @Nullable
    protected abstract String get(String var1);

    protected abstract void put(String var1, String var2);

    protected abstract void remove(String var1);

    final void replace(String key, @Nullable String value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }
}

