/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.internal.InternalPropagation;
import brave.internal.Lists;
import brave.internal.PropagationFields;
import brave.propagation.TraceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PropagationFieldsFactory<P extends PropagationFields> {
    protected abstract Class<P> type();

    protected abstract P create();

    protected abstract P create(P var1);

    public final TraceContext decorate(TraceContext context) {
        long traceId = context.traceId();
        long spanId = context.spanId();
        Class<P> type = this.type();
        List<Object> extraFields = context.extra();
        int extraSize = extraFields.size();
        if (extraSize == 0) {
            extraFields = Collections.singletonList(this.createExtraAndClaim(traceId, spanId));
            return this.contextWithExtra(context, extraFields);
        }
        Object extra = extraFields.get(0);
        PropagationFields consolidatedFields = null;
        if (type.isInstance(extra)) {
            PropagationFields existing = (PropagationFields)extra;
            if (existing.tryToClaim(traceId, spanId)) {
                consolidatedFields = existing;
            } else {
                consolidatedFields = this.createExtraAndClaim(traceId, spanId);
                consolidatedFields.putAllIfAbsent(existing);
            }
        }
        if (extraSize == 1) {
            if (consolidatedFields != null) {
                if (consolidatedFields == extra) {
                    return context;
                }
                return this.contextWithExtra(context, Collections.singletonList(consolidatedFields));
            }
            extraFields = new ArrayList<Object>(2);
            extraFields.add(extra);
            extraFields.add(this.createExtraAndClaim(traceId, spanId));
            return this.contextWithExtra(context, Collections.unmodifiableList(extraFields));
        }
        for (int i = 1; i < extraSize; ++i) {
            extra = extraFields.get(i);
            if (!type.isInstance(extra)) continue;
            PropagationFields existing = (PropagationFields)extra;
            if (consolidatedFields == null) {
                if (existing.tryToClaim(traceId, spanId)) {
                    consolidatedFields = existing;
                    continue;
                }
                consolidatedFields = this.createExtraAndClaim(traceId, spanId);
                consolidatedFields.putAllIfAbsent(existing);
                extraFields = Lists.ensureMutable(extraFields);
                extraFields.set(i, consolidatedFields);
                continue;
            }
            consolidatedFields.putAllIfAbsent(existing);
            extraFields = Lists.ensureMutable(extraFields);
            extraFields.remove(i);
            --extraSize;
            --i;
        }
        if (consolidatedFields == null) {
            consolidatedFields = this.createExtraAndClaim(traceId, spanId);
            extraFields = Lists.ensureMutable(extraFields);
            extraFields.add(consolidatedFields);
        }
        if (extraFields == context.extra()) {
            return context;
        }
        return this.contextWithExtra(context, Collections.unmodifiableList(extraFields));
    }

    P createExtraAndClaim(long traceId, long spanId) {
        P consolidatedFields = this.create();
        ((PropagationFields)consolidatedFields).tryToClaim(traceId, spanId);
        return consolidatedFields;
    }

    protected TraceContext contextWithExtra(TraceContext context, List<Object> immutableExtra) {
        return InternalPropagation.instance.withExtra(context, immutableExtra);
    }
}

