/*
 * Decompiled with CFR 0.152.
 */
package brave.handler;

import brave.Span;
import brave.internal.IpLiteral;
import brave.internal.Nullable;
import java.util.ArrayList;
import java.util.Locale;

public final class MutableSpan
implements Cloneable {
    Span.Kind kind;
    boolean shared;
    long startTimestamp;
    long finishTimestamp;
    String name;
    String localServiceName;
    String localIp;
    String remoteServiceName;
    String remoteIp;
    int localPort;
    int remotePort;
    ArrayList<String> tags = new ArrayList();
    ArrayList<Object> annotations;
    Throwable error;

    @Nullable
    public String name() {
        return this.name;
    }

    public void name(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.name = name;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long finishTimestamp() {
        return this.finishTimestamp;
    }

    public void finishTimestamp(long finishTimestamp) {
        this.finishTimestamp = finishTimestamp;
    }

    public Span.Kind kind() {
        return this.kind;
    }

    public void kind(Span.Kind kind) {
        if (kind == null) {
            throw new NullPointerException("kind == null");
        }
        this.kind = kind;
    }

    @Nullable
    public String localServiceName() {
        return this.localServiceName;
    }

    public void localServiceName(String localServiceName) {
        if (localServiceName == null || localServiceName.isEmpty()) {
            throw new NullPointerException("localServiceName is empty");
        }
        this.localServiceName = localServiceName.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public String localIp() {
        return this.localIp;
    }

    public boolean localIp(@Nullable String localIp) {
        this.localIp = IpLiteral.ipOrNull(localIp);
        return true;
    }

    public int localPort() {
        return this.localPort;
    }

    public void localPort(int localPort) {
        if (localPort > 65535) {
            throw new IllegalArgumentException("invalid port " + localPort);
        }
        if (localPort < 0) {
            localPort = 0;
        }
        this.localPort = localPort;
    }

    @Nullable
    public String remoteServiceName() {
        return this.remoteServiceName;
    }

    public void remoteServiceName(String remoteServiceName) {
        if (remoteServiceName == null || remoteServiceName.isEmpty()) {
            throw new NullPointerException("remoteServiceName is empty");
        }
        this.remoteServiceName = remoteServiceName.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public String remoteIp() {
        return this.remoteIp;
    }

    public int remotePort() {
        return this.remotePort;
    }

    public boolean remoteIpAndPort(@Nullable String remoteIp, int remotePort) {
        if (remoteIp == null) {
            return false;
        }
        this.remoteIp = IpLiteral.ipOrNull(remoteIp);
        if (this.remoteIp == null) {
            return false;
        }
        if (remotePort > 65535) {
            throw new IllegalArgumentException("invalid port " + remotePort);
        }
        if (remotePort < 0) {
            remotePort = 0;
        }
        this.remotePort = remotePort;
        return true;
    }

    public void annotate(long timestamp, String value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (timestamp == 0L) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(timestamp);
        this.annotations.add(value);
    }

    public Throwable error() {
        return this.error;
    }

    public void error(Throwable error) {
        this.error = error;
    }

    @Nullable
    public String tag(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        String result = null;
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            if (!key.equals(this.tags.get(i))) continue;
            result = this.tags.get(i + 1);
        }
        return result;
    }

    public void tag(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            if (!key.equals(this.tags.get(i))) continue;
            this.tags.set(i + 1, value);
            return;
        }
        this.tags.add(key);
        this.tags.add(value);
    }

    public <T> void forEachTag(TagConsumer<T> tagConsumer, T target) {
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            tagConsumer.accept(target, this.tags.get(i), this.tags.get(i + 1));
        }
    }

    public void forEachTag(TagUpdater tagUpdater) {
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            String newValue;
            String value = this.tags.get(i + 1);
            if (!MutableSpan.updateOrRemove(this.tags, i, value, newValue = tagUpdater.update(this.tags.get(i), value))) continue;
            length -= 2;
            i -= 2;
        }
    }

    public <T> void forEachAnnotation(AnnotationConsumer<T> annotationConsumer, T target) {
        if (this.annotations == null) {
            return;
        }
        int length = this.annotations.size();
        for (int i = 0; i < length; i += 2) {
            long timestamp = (Long)this.annotations.get(i);
            annotationConsumer.accept(target, timestamp, this.annotations.get(i + 1).toString());
        }
    }

    public void forEachAnnotation(AnnotationUpdater annotationUpdater) {
        if (this.annotations == null) {
            return;
        }
        int length = this.annotations.size();
        for (int i = 0; i < length; i += 2) {
            String newValue;
            String value = this.annotations.get(i + 1).toString();
            if (!MutableSpan.updateOrRemove(this.annotations, i, value, newValue = annotationUpdater.update((Long)this.annotations.get(i), value))) continue;
            length -= 2;
            i -= 2;
        }
    }

    static boolean updateOrRemove(ArrayList list, int i, Object value, @Nullable Object newValue) {
        if (newValue == null) {
            list.remove(i);
            list.remove(i);
            return true;
        }
        if (!value.equals(newValue)) {
            list.set(i + 1, newValue);
        }
        return false;
    }

    public boolean shared() {
        return this.shared;
    }

    public void setShared() {
        this.shared = true;
    }

    public static interface AnnotationUpdater {
        @Nullable
        public String update(long var1, String var3);
    }

    public static interface TagUpdater {
        @Nullable
        public String update(String var1, String var2);
    }

    public static interface AnnotationConsumer<T> {
        public void accept(T var1, long var2, String var4);
    }

    public static interface TagConsumer<T> {
        public void accept(T var1, String var2, String var3);
    }
}

