/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Span;
import java.util.ArrayList;
import java.util.List;
import zipkin2.Endpoint;
import zipkin2.Span;

public final class SpanRecord {
    Span.Kind kind;
    boolean shared;
    long startTimestamp;
    long finishTimestamp;
    String name;
    Endpoint localEndpoint;
    Endpoint remoteEndpoint;
    final List<Object> pairs = new ArrayList<Object>(6);

    public void startTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public void name(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.name = name;
    }

    public void kind(Span.Kind kind) {
        if (kind == null) {
            throw new NullPointerException("kind == null");
        }
        this.kind = kind;
    }

    public void annotate(long timestamp, String value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (timestamp == 0L) {
            return;
        }
        this.pairs.add(timestamp);
        this.pairs.add(value);
    }

    public void tag(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int length = this.pairs.size();
        for (int i = 0; i < length; i += 2) {
            if (!key.equals(this.pairs.get(i))) continue;
            this.pairs.set(i + 1, value);
            return;
        }
        this.pairs.add(key);
        this.pairs.add(value);
    }

    public void localEndpoint(Endpoint localEndpoint) {
        if (localEndpoint == null) {
            throw new NullPointerException("localEndpoint == null");
        }
        this.localEndpoint = localEndpoint;
    }

    public void remoteEndpoint(Endpoint remoteEndpoint) {
        if (remoteEndpoint == null) {
            throw new NullPointerException("remoteEndpoint == null");
        }
        this.remoteEndpoint = remoteEndpoint;
    }

    public void setShared() {
        this.shared = true;
    }

    public void finishTimestamp(long finishTimestamp) {
        this.finishTimestamp = finishTimestamp;
    }

    public void writeTo(Span.Builder result) {
        result.localEndpoint(this.localEndpoint);
        result.remoteEndpoint(this.remoteEndpoint);
        result.name(this.name);
        result.timestamp(this.startTimestamp);
        if (this.startTimestamp != 0L && this.finishTimestamp != 0L) {
            result.duration(Math.max(this.finishTimestamp - this.startTimestamp, 1L));
        }
        if (this.kind != null && this.kind.ordinal() < Span.Kind.values().length) {
            result.kind(Span.Kind.values()[this.kind.ordinal()]);
        }
        int length = this.pairs.size();
        for (int i = 0; i < length; i += 2) {
            Object first = this.pairs.get(i);
            String second = this.pairs.get(i + 1).toString();
            if (first instanceof Long) {
                result.addAnnotation(((Long)first).longValue(), second);
                continue;
            }
            result.putTag(first.toString(), second);
        }
        if (this.shared) {
            result.shared(true);
        }
    }

    SpanRecord() {
    }
}

