/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.internal.Nullable;
import brave.internal.recorder.PendingSpanRecord;
import brave.internal.recorder.SpanRecord;
import brave.internal.recorder.TickClock;
import brave.propagation.TraceContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public final class PendingSpanRecords
extends ReferenceQueue<TraceContext> {
    final ConcurrentMap<Object, PendingSpanRecord> delegate = new ConcurrentHashMap<Object, PendingSpanRecord>(64);
    final Endpoint endpoint;
    final Clock clock;
    final Reporter<Span> reporter;
    final AtomicBoolean noop;

    public PendingSpanRecords(Endpoint endpoint, Clock clock, Reporter<Span> reporter, AtomicBoolean noop) {
        this.endpoint = endpoint;
        this.clock = clock;
        this.reporter = reporter;
        this.noop = noop;
    }

    @Nullable
    PendingSpanRecord get(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.reportOrphanedSpans();
        return (PendingSpanRecord)this.delegate.get(new LookupKey(context));
    }

    public PendingSpanRecord getOrCreate(TraceContext context) {
        PendingSpanRecord newSpan;
        PendingSpanRecord previousSpan;
        PendingSpanRecord result = this.get(context);
        if (result != null) {
            return result;
        }
        TickClock clock = this.getClockFromParent(context);
        if (clock == null) {
            clock = new TickClock(this.clock.currentTimeMicroseconds(), System.nanoTime());
        }
        SpanRecord data = new SpanRecord();
        data.localEndpoint(this.endpoint);
        if (context.shared()) {
            data.setShared();
        }
        if ((previousSpan = this.delegate.putIfAbsent(new RealKey(context, this), newSpan = new PendingSpanRecord(data, clock))) != null) {
            return previousSpan;
        }
        return newSpan;
    }

    @Nullable
    TickClock getClockFromParent(TraceContext context) {
        PendingSpanRecord parent;
        long parentId = context.parentIdAsLong();
        if (Boolean.TRUE.equals(context.shared())) {
            TraceContext.Builder lookupContext = context.toBuilder().shared(false);
            if (parentId != 0L) {
                lookupContext.spanId(parentId);
            }
            parent = (PendingSpanRecord)this.delegate.get(new LookupKey(lookupContext.build()));
        } else {
            parent = parentId == 0L ? null : (PendingSpanRecord)this.delegate.get(new LookupKey(context.toBuilder().spanId(parentId).build()));
        }
        return parent != null ? parent.clock : null;
    }

    @Nullable
    public boolean remove(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        PendingSpanRecord last = (PendingSpanRecord)this.delegate.remove(new LookupKey(context));
        this.reportOrphanedSpans();
        return last != null;
    }

    void reportOrphanedSpans() {
        RealKey contextKey;
        Span.Builder builder = null;
        long flushTime = 0L;
        while ((contextKey = (RealKey)this.poll()) != null) {
            PendingSpanRecord value = (PendingSpanRecord)this.delegate.remove(contextKey);
            if (value == null || this.noop.get() || !contextKey.sampled) continue;
            if (builder != null) {
                builder.clear();
            } else {
                builder = Span.newBuilder();
                flushTime = this.clock.currentTimeMicroseconds();
            }
            Span.Builder builderWithContextData = Span.newBuilder().traceId(contextKey.traceIdHigh, contextKey.traceId).id(contextKey.spanId).addAnnotation(flushTime, "brave.flush");
            value.span.writeTo(builderWithContextData);
            this.reporter.report((Object)builderWithContextData.build());
        }
    }

    public List<Span> snapshot() {
        ArrayList<Span> result = new ArrayList<Span>();
        Span.Builder spanBuilder = Span.newBuilder();
        for (Map.Entry entry : this.delegate.entrySet()) {
            RealKey contextKey = (RealKey)entry.getKey();
            spanBuilder.clear().traceId(contextKey.traceIdHigh, contextKey.traceId).id(contextKey.spanId);
            ((PendingSpanRecord)entry.getValue()).span.writeTo(spanBuilder);
            result.add(spanBuilder.build());
            spanBuilder.clear();
        }
        return result;
    }

    public String toString() {
        return "PendingSpanRecords" + this.delegate.keySet();
    }

    static final class LookupKey {
        final TraceContext context;

        LookupKey(TraceContext context) {
            this.context = context;
        }

        public int hashCode() {
            return this.context.hashCode();
        }

        public boolean equals(Object other) {
            return this.context.equals(((RealKey)other).get());
        }
    }

    static final class RealKey
    extends WeakReference<TraceContext> {
        final int hashCode;
        final long traceIdHigh;
        final long traceId;
        final long spanId;
        final boolean sampled;

        RealKey(TraceContext context, ReferenceQueue<TraceContext> queue) {
            super(context, queue);
            this.hashCode = context.hashCode();
            this.traceIdHigh = context.traceIdHigh();
            this.traceId = context.traceId();
            this.spanId = context.spanId();
            this.sampled = Boolean.TRUE.equals(context.sampled());
        }

        public String toString() {
            TraceContext context = (TraceContext)this.get();
            return context != null ? "WeakReference(" + context + ")" : "ClearedReference()";
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            TraceContext thisContext = (TraceContext)this.get();
            TraceContext thatContext = (TraceContext)((RealKey)other).get();
            if (thisContext == null) {
                return thatContext == null;
            }
            return thisContext.equals(thatContext);
        }
    }
}

