/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.NoopScopedSpan;
import brave.NoopSpan;
import brave.NoopSpanCustomizer;
import brave.RealScopedSpan;
import brave.RealSpan;
import brave.RealSpanCustomizer;
import brave.ScopedSpan;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.recorder.PendingSpanRecord;
import brave.internal.recorder.PendingSpanRecords;
import brave.internal.recorder.SpanRecord;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer {
    final Clock clock;
    final Propagation.Factory propagationFactory;
    final Tracing.SpanReporter spanReporter;
    final PendingSpanRecords pendingSpanRecords;
    final Sampler sampler;
    final ErrorParser errorParser;
    final CurrentTraceContext currentTraceContext;
    final boolean traceId128Bit;
    final boolean supportsJoin;
    final AtomicBoolean noop;

    Tracer(Clock clock, Propagation.Factory propagationFactory, Tracing.SpanReporter spanReporter, PendingSpanRecords pendingSpanRecords, Sampler sampler, ErrorParser errorParser, CurrentTraceContext currentTraceContext, boolean traceId128Bit, boolean supportsJoin, AtomicBoolean noop) {
        this.clock = clock;
        this.propagationFactory = propagationFactory;
        this.spanReporter = spanReporter;
        this.pendingSpanRecords = pendingSpanRecords;
        this.sampler = sampler;
        this.errorParser = errorParser;
        this.currentTraceContext = currentTraceContext;
        this.traceId128Bit = traceId128Bit;
        this.supportsJoin = supportsJoin;
        this.noop = noop;
    }

    public Tracer withSampler(Sampler sampler) {
        if (sampler == null) {
            throw new NullPointerException("sampler == null");
        }
        return new Tracer(this.clock, this.propagationFactory, this.spanReporter, this.pendingSpanRecords, sampler, this.errorParser, this.currentTraceContext, this.traceId128Bit, this.supportsJoin, this.noop);
    }

    public Span newTrace() {
        return this.toSpan(this.newContextBuilder(null, this.sampler).build());
    }

    public final Span joinSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.supportsJoin) {
            return this.newChild(context);
        }
        if (context.sampled() == null) {
            context = context.toBuilder().sampled(this.sampler.isSampled(context.traceId())).build();
        } else if (context.sampled().booleanValue()) {
            context = context.toBuilder().shared(true).build();
        }
        return this.toSpan(context);
    }

    public Span newChild(TraceContext parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        return this.toSpan(this.newContextBuilder(parent, this.sampler).build());
    }

    public Span nextSpan(TraceContextOrSamplingFlags extracted) {
        TraceContext parent = extracted.context();
        if (extracted.samplingFlags() != null) {
            TraceContext implicitParent = this.currentTraceContext.get();
            if (implicitParent == null) {
                return this.toSpan(this.newContextBuilder(null, extracted.samplingFlags()).extra(extracted.extra()).build());
            }
            parent = Tracer.appendExtra(implicitParent, extracted.extra());
        }
        if (parent != null) {
            TraceContext.Builder builder = extracted.samplingFlags() != null ? this.newContextBuilder(parent, extracted.samplingFlags()) : this.newContextBuilder(parent, this.sampler);
            return this.toSpan(builder.shared(false).build());
        }
        TraceIdContext traceIdContext = extracted.traceIdContext();
        if (extracted.traceIdContext() != null) {
            Boolean sampled = traceIdContext.sampled();
            if (sampled == null) {
                sampled = this.sampler.isSampled(traceIdContext.traceId());
            }
            return this.toSpan(TraceContext.newBuilder().sampled(sampled).debug(traceIdContext.debug()).traceIdHigh(traceIdContext.traceIdHigh()).traceId(traceIdContext.traceId()).spanId(this.nextId()).extra(extracted.extra()).build());
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        TraceContext decorated = this.propagationFactory.decorate(context);
        if (this.isNoop(decorated)) {
            return new NoopSpan(decorated);
        }
        PendingSpanRecord pendingSpanRecord = this.pendingSpanRecords.getOrCreate(decorated);
        return new RealSpan(decorated, this.pendingSpanRecords, pendingSpanRecord.span(), pendingSpanRecord.clock(), this.spanReporter, this.errorParser);
    }

    public SpanInScope withSpanInScope(@Nullable Span span) {
        return new SpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    public SpanCustomizer currentSpanCustomizer() {
        TraceContext context = this.currentTraceContext.get();
        if (context == null || this.isNoop(context)) {
            return NoopSpanCustomizer.INSTANCE;
        }
        PendingSpanRecord pendingSpanRecord = this.pendingSpanRecords.getOrCreate(context);
        return new RealSpanCustomizer(context, pendingSpanRecord.span(), pendingSpanRecord.clock());
    }

    @Nullable
    public Span currentSpan() {
        TraceContext currentContext = this.currentTraceContext.get();
        return currentContext != null ? this.toSpan(currentContext) : null;
    }

    public Span nextSpan() {
        return this.toSpan(this.newContextBuilder(this.currentTraceContext.get(), this.sampler).build());
    }

    public ScopedSpan startScopedSpan(String name) {
        return this.startScopedSpanWithParent(name, this.currentTraceContext.get());
    }

    public ScopedSpan startScopedSpanWithParent(String name, @Nullable TraceContext parent) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        TraceContext context = this.propagationFactory.decorate(this.newContextBuilder(parent, this.sampler).build());
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(context);
        if (this.isNoop(context)) {
            return new NoopScopedSpan(context, scope);
        }
        PendingSpanRecord pendingSpanRecord = this.pendingSpanRecords.getOrCreate(context);
        Clock clock = pendingSpanRecord.clock();
        SpanRecord record = pendingSpanRecord.span();
        record.name(name);
        record.startTimestamp(clock.currentTimeMicroseconds());
        return new RealScopedSpan(context, scope, record, clock, this.pendingSpanRecords, this.spanReporter, this.errorParser);
    }

    public String toString() {
        TraceContext currentSpan = this.currentTraceContext.get();
        List<zipkin2.Span> inFlight = this.pendingSpanRecords.snapshot();
        return "Tracer{" + (currentSpan != null ? "currentSpan=" + currentSpan + ", " : "") + (inFlight.size() > 0 ? "inFlight=" + inFlight + ", " : "") + (this.noop.get() ? "noop=true, " : "") + "reporter=" + this.spanReporter + "}";
    }

    TraceContext.Builder newContextBuilder(@Nullable TraceContext parent, Sampler sampler) {
        long nextId = this.nextId();
        if (parent != null) {
            Boolean sampled = parent.sampled();
            if (sampled == null) {
                sampled = sampler.isSampled(parent.traceId());
            }
            return parent.toBuilder().spanId(nextId).parentId(parent.spanId()).sampled(sampled);
        }
        return TraceContext.newBuilder().sampled(sampler.isSampled(nextId)).traceIdHigh(this.traceId128Bit ? Platform.get().nextTraceIdHigh() : 0L).traceId(nextId).spanId(nextId);
    }

    boolean isNoop(TraceContext context) {
        return this.noop.get() || !Boolean.TRUE.equals(context.sampled());
    }

    TraceContext.Builder newContextBuilder(TraceContext parent, SamplingFlags samplingFlags) {
        return this.newContextBuilder(parent, this.samplerOverride(samplingFlags)).debug(samplingFlags.debug());
    }

    Sampler samplerOverride(SamplingFlags samplingFlags) {
        Boolean sampled = samplingFlags.sampled();
        return sampled == null ? this.sampler : (sampled != false ? Sampler.ALWAYS_SAMPLE : Sampler.NEVER_SAMPLE);
    }

    long nextId() {
        long nextId = Platform.get().randomLong();
        while (nextId == 0L) {
            nextId = Platform.get().randomLong();
        }
        return nextId;
    }

    static TraceContext appendExtra(TraceContext context, List<Object> extra) {
        if (extra.isEmpty()) {
            return context;
        }
        if (context.extra().isEmpty()) {
            return context.toBuilder().extra(extra).build();
        }
        ArrayList<Object> merged = new ArrayList<Object>(context.extra());
        merged.addAll(extra);
        return context.toBuilder().extra(merged).build();
    }

    public static final class SpanInScope
    implements Closeable {
        final CurrentTraceContext.Scope scope;

        SpanInScope(CurrentTraceContext.Scope scope) {
            if (scope == null) {
                throw new NullPointerException("scope == null");
            }
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }

        public String toString() {
            return this.scope.toString();
        }
    }
}

