/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.RealSpanCustomizer;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.internal.recorder.PendingSpanRecords;
import brave.internal.recorder.SpanRecord;
import brave.propagation.TraceContext;
import zipkin2.Endpoint;

final class RealSpan
extends Span {
    final TraceContext context;
    final PendingSpanRecords pendingSpanRecords;
    final SpanRecord record;
    final Clock clock;
    final Tracing.SpanReporter spanReporter;
    final ErrorParser errorParser;
    final RealSpanCustomizer customizer;

    RealSpan(TraceContext context, PendingSpanRecords pendingSpanRecords, SpanRecord record, Clock clock, Tracing.SpanReporter spanReporter, ErrorParser errorParser) {
        this.context = context;
        this.pendingSpanRecords = pendingSpanRecords;
        this.record = record;
        this.clock = clock;
        this.customizer = new RealSpanCustomizer(context, record, clock);
        this.spanReporter = spanReporter;
        this.errorParser = errorParser;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public TraceContext context() {
        return this.context;
    }

    @Override
    public SpanCustomizer customizer() {
        return new RealSpanCustomizer(this.context, this.record, this.clock);
    }

    @Override
    public Span start() {
        return this.start(this.clock.currentTimeMicroseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span start(long timestamp) {
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.startTimestamp(timestamp);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span name(String name) {
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.name(name);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span kind(Span.Kind kind) {
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.kind(kind);
        }
        return this;
    }

    @Override
    public Span annotate(String value) {
        return this.annotate(this.clock.currentTimeMicroseconds(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span annotate(long timestamp, String value) {
        if ("cs".equals(value)) {
            SpanRecord spanRecord = this.record;
            synchronized (spanRecord) {
                this.record.kind(Span.Kind.CLIENT);
                this.record.startTimestamp(timestamp);
            }
        }
        if ("sr".equals(value)) {
            SpanRecord spanRecord = this.record;
            synchronized (spanRecord) {
                this.record.kind(Span.Kind.SERVER);
                this.record.startTimestamp(timestamp);
            }
        }
        if ("cr".equals(value)) {
            SpanRecord spanRecord = this.record;
            synchronized (spanRecord) {
                this.record.kind(Span.Kind.CLIENT);
            }
            this.finish(timestamp);
        } else if ("ss".equals(value)) {
            SpanRecord spanRecord = this.record;
            synchronized (spanRecord) {
                this.record.kind(Span.Kind.SERVER);
            }
            this.finish(timestamp);
        } else {
            SpanRecord spanRecord = this.record;
            synchronized (spanRecord) {
                this.record.annotate(timestamp, value);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span tag(String key, String value) {
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.tag(key, value);
        }
        return this;
    }

    @Override
    public Span error(Throwable throwable) {
        this.errorParser.error(throwable, this.customizer());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span remoteEndpoint(Endpoint remoteEndpoint) {
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.remoteEndpoint(remoteEndpoint);
        }
        return this;
    }

    @Override
    public void finish() {
        this.finish(this.clock.currentTimeMicroseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(long timestamp) {
        if (!this.pendingSpanRecords.remove(this.context)) {
            return;
        }
        SpanRecord spanRecord = this.record;
        synchronized (spanRecord) {
            this.record.finishTimestamp(timestamp);
        }
        this.spanReporter.report(this.context, this.record);
    }

    @Override
    public void abandon() {
        this.pendingSpanRecords.remove(this.context);
    }

    @Override
    public void flush() {
        this.abandon();
        this.spanReporter.report(this.context, this.record);
    }

    public String toString() {
        return "RealSpan(" + this.context + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealSpan)) {
            return false;
        }
        return this.context.equals(((RealSpan)o).context);
    }

    public int hashCode() {
        return this.context.hashCode();
    }
}

