/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.ScopedSpan;
import brave.Tracing;
import brave.internal.recorder.PendingSpanRecords;
import brave.internal.recorder.SpanRecord;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

final class RealScopedSpan
extends ScopedSpan {
    final TraceContext context;
    final CurrentTraceContext.Scope scope;
    final SpanRecord record;
    final Clock clock;
    final PendingSpanRecords pendingSpanRecords;
    final Tracing.SpanReporter spanReporter;
    final ErrorParser errorParser;

    RealScopedSpan(TraceContext context, CurrentTraceContext.Scope scope, SpanRecord record, Clock clock, PendingSpanRecords pendingSpanRecords, Tracing.SpanReporter spanReporter, ErrorParser errorParser) {
        this.context = context;
        this.scope = scope;
        this.pendingSpanRecords = pendingSpanRecords;
        this.record = record;
        this.clock = clock;
        this.spanReporter = spanReporter;
        this.errorParser = errorParser;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public TraceContext context() {
        return this.context;
    }

    @Override
    public ScopedSpan annotate(String value) {
        this.record.annotate(this.clock.currentTimeMicroseconds(), value);
        return this;
    }

    @Override
    public ScopedSpan tag(String key, String value) {
        this.record.tag(key, value);
        return this;
    }

    @Override
    public ScopedSpan error(Throwable throwable) {
        this.errorParser.error(throwable, this);
        return this;
    }

    @Override
    public void finish() {
        this.scope.close();
        if (!this.pendingSpanRecords.remove(this.context)) {
            return;
        }
        this.spanReporter.report(this.context, this.record);
        this.record.finishTimestamp(this.clock.currentTimeMicroseconds());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealScopedSpan)) {
            return false;
        }
        RealScopedSpan that = (RealScopedSpan)o;
        return this.context.equals(that.context) && this.scope.equals(that.scope);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.context.hashCode();
        h *= 1000003;
        return h ^= this.scope.hashCode();
    }
}

